package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.smart.wx.core.utils.WxCpUtils;

/**
 * 微信小程序服务接口
 *
 * @author guer
 */
public interface WxCpApi {

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    String getAccessToken(String appId);

    /**
     * 获取accessToken
     *
     * @param corpId
     *         corpId
     * @param agentId
     *         agentId
     * @return accessToken
     */
    default String getAccessToken(String corpId, Integer agentId) {
        return getAccessToken(WxCpUtils.buildAppId(corpId, agentId));
    }

    /**
     * 通过code获取用户信息
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 企业微信用户Oauth信息
     */
    WxCpOauth2UserInfoDTO getCodeInfo(String appId, String code);

    /**
     * 通过code获取用户信息
     *
     * @param corpId
     *         corpId
     * @param agentId
     *         agentId
     * @param code
     *         code
     * @return 企业微信用户Oauth信息
     */
    default WxCpOauth2UserInfoDTO getCodeInfo(String corpId, Integer agentId, String code) {
        return getCodeInfo(WxCpUtils.buildAppId(corpId, agentId), code);
    }
}
