/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMpApi;
import net.guerlab.smart.wx.api.autoconfig.WxMpApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.api.feign.FeignWxMpApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={WxMpApiLocalServiceAutoConfigure.class})
public class WxMpApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={WxMpApi.class})
    public WxMpApi wxMpApiFeignWrapper(FeignWxMpApi api) {
        return new WxMpApiFeignWrapper(api);
    }

    private static class WxMpApiFeignWrapper
    implements WxMpApi {
        private FeignWxMpApi api;

        @Override
        public LoginResponse login(String appId, String code) {
            Result<LoginResponse> result = this.api.login(appId, code);
            if (result.isStatus()) {
                return (LoginResponse)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public String getAccessToken(String appId) {
            Result<String> result = this.api.getAccessToken(appId);
            if (result.isStatus()) {
                return (String)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        public WxMpApiFeignWrapper(FeignWxMpApi api) {
            this.api = api;
        }
    }
}

