/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.api.WxAppApi;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class WxAppApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={WxAppService.class})
    public WxAppApi wxAppApiLocalServiceWrapper(WxAppService service) {
        return new WxAppApiLocalServiceWrapper(service);
    }

    private static class WxAppApiLocalServiceWrapper
    implements WxAppApi {
        private WxAppService service;

        @Override
        public WxAppDTO findOne(String appId) {
            return (WxAppDTO)((WxApp)this.service.selectByIdOptional((Object)appId).orElseThrow(WxAppInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<WxAppDTO> findList(WxAppSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<WxAppDTO> findAll(WxAppSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public WxAppApiLocalServiceWrapper(WxAppService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.wx.service.service.WxAppService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

