package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxMpTemplateMsgApiFallbackFactory;
import net.guerlab.smart.wx.lib.domain.SendMsgResponse;
import net.guerlab.smart.wx.lib.domain.WxMpTemplateMessageSendData;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

/**
 * 微信公众号模版消息服务接口
 *
 * @author guer
 */
@FeignClient(name = "wx-internal/inside/wxMpTemplateMsg", fallbackFactory = FeignWxMpTemplateMsgApiFallbackFactory.class)
public interface FeignWxMpTemplateMsgApi {

    /**
     * 发送模板消息
     *
     * @param appId
     *         应用ID
     * @param sendData
     *         请求数据
     * @return 发送结果
     */
    @PostMapping("/{appId}/sendMsg")
    Result<Map<String, SendMsgResponse>> sendMsg(@PathVariable("appId") String appId,
            @RequestBody WxMpTemplateMessageSendData sendData);
}
