/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import net.guerlab.smart.wx.api.feign.FeignWxMaApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignWxMaApiFallbackFactory
implements FallbackFactory<FeignWxMaApi> {
    public FeignWxMaApi create(Throwable cause) {
        return new FeignWxMaApiFallback(cause);
    }

    static class FeignWxMaApiFallback
    implements FeignWxMaApi {
        private static final Logger log = LoggerFactory.getLogger(FeignWxMaApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<LoginResponse> login(String appId, String code) {
            log.error("login fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<LoginResponse> register(String appId, String openId, MaEncryptedData encryptedData) {
            log.error("register fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<String> getAccessToken(String appId) {
            log.error("getAccessToken fallback", this.cause);
            return new Fail("fallback");
        }

        public FeignWxMaApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

