/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.wx.api.WxAppApi;
import net.guerlab.smart.wx.api.autoconfig.WxAppApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.api.feign.FeignWxAppApi;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={WxAppApiLocalServiceAutoConfigure.class})
public class WxAppApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={WxAppApi.class})
    public WxAppApi wxAppApiFeignWrapper(FeignWxAppApi api) {
        return new WxAppApiFeignWrapper(api);
    }

    private static class WxAppApiFeignWrapper
    implements WxAppApi {
        private FeignWxAppApi api;

        @Override
        public WxAppDTO findOne(String appId) {
            return Optional.ofNullable((WxAppDTO)this.api.findOne(appId).getData()).orElseThrow(WxAppInvalidException::new);
        }

        @Override
        public ListObject<WxAppDTO> findList(WxAppSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<WxAppDTO> findAll(WxAppSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public WxAppApiFeignWrapper(FeignWxAppApi api) {
            this.api = api;
        }
    }
}

