package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxAppApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 微信应用服务接口
 *
 * @author guer
 */
@FeignClient(name = "wx-internal/inside/wxApp", fallbackFactory = FeignWxAppApiFallbackFactory.class)
public interface FeignWxAppApi {

    /**
     * 根据微信应用id查询微信应用
     *
     * @param appId
     *         appId
     * @return 微信应用
     */
    @GetMapping("/{appId}")
    Result<WxAppDTO> findOne(@PathVariable("appId") String appId);

    /**
     * 根据搜索参数查询微信应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信应用列表
     */
    @PostMapping
    Result<ListObject<WxAppDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询微信应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信应用列表
     */
    @PostMapping("/all")
    Result<List<WxAppDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
