package net.guerlab.smart.wx.api.autoconfig;

import lombok.AllArgsConstructor;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMpApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.service.service.WxMpLoginService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

/**
 * @author guer
 */
@Configuration
@Conditional(WxMpApiLocalServiceAutoConfigure.WrapperCondition.class)
public class WxMpApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(WxMpLoginService.class)
    public WxMpApi wxMpApiLocalServiceWrapper(WxMpLoginService service, WxMpManagerService managerService) {
        return new WxMpApiLocalServiceWrapper(service, managerService);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                ClassLoader classLoader = WrapperCondition.class.getClassLoader();
                return classLoader.loadClass("net.guerlab.smart.wx.service.service.WxMpLoginService") != null
                        && classLoader.loadClass("net.guerlab.smart.wx.service.service.WxMpManagerService") != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class WxMpApiLocalServiceWrapper implements WxMpApi {

        private WxMpLoginService service;

        private WxMpManagerService managerService;

        @Override
        public LoginResponse login(String appId, String code) {
            try {
                return service.login(appId, code);
            } catch (Exception e) {
                throw new ApplicationException(e.getLocalizedMessage(), e);
            }
        }

        @Override
        public String getAccessToken(String appId) {
            try {
                return managerService.getService(appId).getAccessToken();
            } catch (WxErrorException e) {
                throw new ApplicationException(e.getError().getErrorMsg(), e.getError().getErrorCode());
            }
        }
    }

}
