/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.wx.api.feign.FeignWxAppApi;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignWxAppApiFallbackFactory
implements FallbackFactory<FeignWxAppApi> {
    public FeignWxAppApi create(Throwable cause) {
        return new FeignWxAppApiFallback(cause);
    }

    static class FeignWxAppApiFallback
    implements FeignWxAppApi {
        private static final Logger log = LoggerFactory.getLogger(FeignWxAppApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<WxAppDTO> findOne(String appId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<WxAppDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<WxAppDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignWxAppApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

