package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxMaApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

/**
 * 微信小程序服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxMaApiFallbackFactory implements FallbackFactory<FeignWxMaApi> {

    @Override
    public FeignWxMaApi create(Throwable cause) {
        return new FeignWxMaApiFallback(cause);
    }

    /**
     * 微信小程序服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxMaApiFallback implements FeignWxMaApi {

        private final Throwable cause;

        @Override
        public Result<LoginResponse> login(String appId, String code) {
            log.error("login fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<LoginResponse> register(String appId, String openId, MaEncryptedData encryptedData) {
            log.error("register fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<String> getAccessToken(String appId) {
            log.error("getAccessToken fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
