package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxMaApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 微信小程序服务接口
 *
 * @author guers
 */
@FeignClient(name = "wx-internal/inside/wx/ma", fallbackFactory = FeignWxMaApiFallbackFactory.class)
public interface FeignWxMaApi {

    /**
     * 换取token
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 微信用户
     */
    @GetMapping("/{appId}/login/{code}")
    Result<LoginResponse> login(@PathVariable String appId, @PathVariable String code);

    /**
     * 注册用户
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @param encryptedData
     *         小程序加密信息请求
     * @return 微信用户
     */
    @PostMapping("/{appId}/register/{openId}")
    Result<LoginResponse> register(@PathVariable String appId, @PathVariable String openId,
            @RequestBody MaEncryptedData encryptedData);

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    @GetMapping("/{appId}/accessToken")
    Result<String> getAccessToken(@PathVariable String appId);
}
