package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 微信用户服务接口
 *
 * @author guer
 */
public interface WxUserApi {

    /**
     * 根据appId和openId查询微信用户
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @return 微信用户
     */
    WxUserDTO findOne(String appId, String openId);

    /**
     * 根据搜索参数查询微信用户列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户列表
     */
    ListObject<WxUserDTO> findList(WxUserSearchParams searchParams);

    /**
     * 根据搜索参数查询微信用户列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户列表
     */
    List<WxUserDTO> findAll(WxUserSearchParams searchParams);
}
