/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpOauth2UserInfo;
import net.guerlab.smart.platform.basic.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.commons.exception.UnsupportedLoginModeException;
import net.guerlab.smart.platform.user.web.controller.AbstractOauthControlPanelController;
import net.guerlab.smart.platform.user.web.domain.LoginResponse;
import net.guerlab.smart.wx.cp.spring.exception.IsNotCompanyUserException;
import net.guerlab.smart.wx.cp.spring.exception.WxCpCodeEmptyException;
import net.guerlab.smart.wx.cp.spring.manager.WxCpServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u5fae\u4fe1-\u63a7\u5236\u9762\u677f"})
@RestController(value="/user/wx/cp/controlPanel")
@RequestMapping(value={"/user/wx/cp/controlPanel"})
public class WxCpControlPanelController
extends AbstractOauthControlPanelController {
    private WxCpServiceManager wxCpServiceManager;

    @Override
    protected String getOauthType() {
        return "WORK_WEIXIN";
    }

    @IgnoreLogin
    @ApiOperation(value="\u901a\u8fc7code\u767b\u5f55")
    @GetMapping(value={"/{agentId}/loginByCode"})
    public LoginResponse loginByCode(@ApiParam(value="agentId", required=true) @PathVariable Integer agentId, @ApiParam(value="code", required=true) @RequestParam String code, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new WxCpCodeEmptyException();
        }
        WxCpOauth2UserInfo userInfo = this.getWxCpService(agentId).getOauth2Service().getUserInfo(code);
        String userId = userInfo.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new IsNotCompanyUserException();
        }
        return this.getLoginSucceedDTO(this.findUser(userId), userId, request, this.getOauthType());
    }

    private WxCpService getWxCpService(Integer agentId) {
        if (this.wxCpServiceManager == null) {
            throw new UnsupportedLoginModeException();
        }
        WxCpService wxCpService = this.wxCpServiceManager.getWxCpService(agentId);
        if (wxCpService == null) {
            throw new UnsupportedLoginModeException();
        }
        return wxCpService;
    }

    @Autowired(required=false)
    public void setWxCpServiceManager(WxCpServiceManager wxCpServiceManager) {
        this.wxCpServiceManager = wxCpServiceManager;
    }
}

