/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Objects;
import net.guerlab.smart.platform.commons.exception.PermissionsErrorException;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.platform.user.core.domain.PositionDataDTO;
import net.guerlab.smart.platform.user.core.domain.UserDTO;
import net.guerlab.smart.platform.user.core.domain.UserModifyDTO;
import net.guerlab.smart.platform.user.core.exception.NeedPasswordException;
import net.guerlab.smart.platform.user.core.exception.UserCannotDeleteException;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.service.PositionGetHandler;
import net.guerlab.smart.platform.user.service.service.UserService;
import net.guerlab.spring.commons.dto.ConvertDTO;
import net.guerlab.spring.upload.entity.IFileInfo;
import net.guerlab.spring.upload.generator.DateSavePathGenerator;
import net.guerlab.spring.upload.generator.RandomSaveNameGenerator;
import net.guerlab.spring.upload.generator.SaveNameGenerator;
import net.guerlab.spring.upload.generator.SavePathGenerator;
import net.guerlab.spring.upload.helper.UploadFileHelper;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u6237"})
@RestController(value="/user/user")
@RequestMapping(value={"/user/user"})
public class UserController {
    private UserService service;
    private PositionGetHandler positionGetHandler;

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public UserDTO findOne(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return (UserDTO)this.findOne0(id).toDTO();
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @GetMapping
    public ListObject<UserDTO> findList(UserSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.queryPage(searchParams));
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8")
    @GetMapping(value={"/all"})
    public Collection<UserDTO> findAll(UserSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.queryAll(searchParams));
    }

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping
    @Transactional(rollbackFor={Exception.class})
    public UserDTO save(@ApiParam(value="\u7528\u6237\u7f16\u8f91\u4fe1\u606f", required=true) @RequestBody UserModifyDTO dto) {
        String password = StringUtils.trimToNull((String)dto.getPassword());
        if (password == null) {
            throw new NeedPasswordException();
        }
        User user = new User();
        BeanUtils.copyProperties((Object)dto, (Object)user);
        if (!this.service.isAdmin(UserContextHandler.getUserId())) {
            user.setAdmin(Boolean.valueOf(false));
        }
        this.service.insertSelective((Object)user);
        return (UserDTO)user.toDTO();
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/{id}"})
    @Transactional(rollbackFor={Exception.class})
    public UserDTO update(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u7528\u6237\u7f16\u8f91\u4fe1\u606f", required=true) @RequestBody UserModifyDTO dto) {
        User user = this.findOne0(id);
        Long departmentId = dto.getDepartmentId();
        Long nowDepartmentId = user.getDepartmentId();
        Long mainDutyId = dto.getMainDutyId();
        Long nowMainDutyId = user.getMainDutyId();
        BeanUtils.copyProperties((Object)dto, (Object)user);
        user.setUserId(id);
        user.setOldDepartmentId(nowDepartmentId);
        user.setOldMainDutyId(nowMainDutyId);
        if (Objects.equals(departmentId, nowDepartmentId)) {
            user.setDepartmentId(null);
        } else {
            user.setDepartmentId(departmentId);
        }
        if (Objects.equals(mainDutyId, nowMainDutyId)) {
            user.setMainDutyId(null);
        } else {
            user.setMainDutyId(mainDutyId);
        }
        if (!this.service.isAdmin(UserContextHandler.getUserId())) {
            user.setAdmin(null);
        }
        this.service.updateSelectiveById((Object)user);
        return (UserDTO)this.findOne0(id).toDTO();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    @Transactional(rollbackFor={Exception.class})
    public void delete(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u5f3a\u5236\u5220\u9664\u6807\u5fd7") @RequestParam(required=false) Boolean force) {
        Long currentUserId = UserContextHandler.getUserId();
        if (Objects.equals(id, currentUserId)) {
            throw new UserCannotDeleteException();
        }
        User user = this.findOne0(id);
        if (user.getAdmin().booleanValue() && !this.service.isAdmin(currentUserId)) {
            throw new PermissionsErrorException();
        }
        this.service.deleteById((Object)id, force);
    }

    @ApiOperation(value="\u5220\u9664\u5934\u50cf")
    @PostMapping(value={"/{id}/deleteAvatar"})
    public UserDTO deleteAvatar(@ApiParam(value="id", required=true) @PathVariable Long id) {
        this.service.deleteAvatar(id);
        User user = (User)this.service.selectById((Object)id);
        return (UserDTO)BeanConvertUtils.toObject((ConvertDTO)user);
    }

    @ApiOperation(value="\u5934\u50cf\u4e0a\u4f20")
    @PostMapping(value={"/uploadAvatar"})
    public IFileInfo avatar(@ApiParam(value="\u5934\u50cf\u56fe\u7247\u6587\u4ef6", required=true) @RequestParam MultipartFile file) {
        return UploadFileHelper.upload((MultipartFile)file, (SavePathGenerator)new DateSavePathGenerator("avatar"), (SaveNameGenerator)RandomSaveNameGenerator.INSTANCE);
    }

    @ApiOperation(value="\u83b7\u53d6\u6743\u9650\u5173\u952e\u5b57\u5217\u8868")
    @GetMapping(value={"/{id}/permissionKeys"})
    public Collection<String> permissionKeys(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return this.service.getPermissionKeys(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u804c\u52a1\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/{id}/position"})
    public Collection<PositionDataDTO> getPosition(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return this.positionGetHandler.getPosition(id);
    }

    private User findOne0(Long id) {
        return (User)this.service.selectByIdOptional((Object)id).orElseThrow(UserInvalidException::new);
    }

    @Autowired
    public void setService(UserService service) {
        this.service = service;
    }

    @Autowired
    public void setPositionGetHandler(PositionGetHandler positionGetHandler) {
        this.positionGetHandler = positionGetHandler;
    }
}

