/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.exception.UserIdInvalidException;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.user.core.UserAuthConstants;
import net.guerlab.smart.platform.user.core.domain.DepartmentDTO;
import net.guerlab.smart.platform.user.core.domain.DutyDTO;
import net.guerlab.smart.platform.user.core.domain.PositionDTO;
import net.guerlab.smart.platform.user.core.domain.UserDTO;
import net.guerlab.smart.platform.user.core.exception.DepartmentIdInvalidException;
import net.guerlab.smart.platform.user.core.exception.DepartmentNotHasDutyDistributionException;
import net.guerlab.smart.platform.user.core.exception.MainDutyCannotDeleteException;
import net.guerlab.smart.platform.user.core.exception.SystemDutyCannotOperationException;
import net.guerlab.smart.platform.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.DutySearchParams;
import net.guerlab.smart.platform.user.core.searchparams.PositionSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.Department;
import net.guerlab.smart.platform.user.service.entity.Duty;
import net.guerlab.smart.platform.user.service.entity.Position;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.service.DepartmentDutyDistributionService;
import net.guerlab.smart.platform.user.service.service.DepartmentService;
import net.guerlab.smart.platform.user.service.service.DutyService;
import net.guerlab.smart.platform.user.service.service.PositionService;
import net.guerlab.smart.platform.user.service.service.UserService;
import net.guerlab.smart.platform.user.web.domain.PositionBatchRequest;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u804c\u4f4d"})
@RestController(value="/user/position")
@RequestMapping(value={"/user/position"})
public class PositionController {
    private PositionService positionService;
    private UserService userService;
    private DepartmentService departmentService;
    private DutyService dutyService;
    private DepartmentDutyDistributionService distributionService;

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/queryByUserIds"})
    public Map<Long, List<PositionDTO>> query(@RequestBody Collection<Long> userIds) {
        List dutyIds;
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setUserIds(userIds);
        List list = BeanConvertUtils.toList((Collection)this.positionService.findList(searchParams));
        Map map = CollectionUtil.group((Collection)list, PositionDTO::getUserId);
        if (map.isEmpty()) {
            return map;
        }
        List departmentIds = CollectionUtil.toList((Collection)list, PositionDTO::getDepartmentId);
        if (!departmentIds.isEmpty()) {
            DepartmentSearchParams departmentSearchParams = new DepartmentSearchParams();
            departmentSearchParams.setDepartmentIds((Collection)departmentIds);
            Map departmentMap = CollectionUtil.toMap((Collection)this.departmentService.selectAll((AbstractSearchParams)departmentSearchParams), Department::getDepartmentId, DefaultConvertDTO::toDTO);
            list.forEach(position -> position.setDepartment((DepartmentDTO)departmentMap.get(position.getDepartmentId())));
        }
        if (!(dutyIds = CollectionUtil.toList((Collection)list, PositionDTO::getDutyId)).isEmpty()) {
            DutySearchParams dutySearchParams = new DutySearchParams();
            dutySearchParams.setDutyIds((Collection)dutyIds);
            Map dutyMap = CollectionUtil.toMap((Collection)this.dutyService.selectAll((AbstractSearchParams)dutySearchParams), Duty::getDutyId, DefaultConvertDTO::toDTO);
            list.forEach(position -> position.setDuty((DutyDTO)dutyMap.get(position.getDutyId())));
        }
        return map;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @GetMapping
    public ListObject<PositionDTO> findList(PositionSearchParams searchParams) {
        ListObject result = BeanConvertUtils.toListObject((ListObject)this.positionService.findPage(searchParams));
        this.set(result.getList());
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8")
    @GetMapping(value={"/all"})
    public List<PositionDTO> findAll(PositionSearchParams searchParams) {
        List list = BeanConvertUtils.toList((Collection)this.positionService.findList(searchParams));
        this.set(list);
        return list;
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @PostMapping(value={"/{userId}/{departmentId}/{dutyId}"})
    @Transactional(rollbackFor={Exception.class})
    public void save(@ApiParam(value="\u7528\u6237id", required=true) @PathVariable Long userId, @ApiParam(value="\u90e8\u95e8id", required=true) @PathVariable Long departmentId, @ApiParam(value="\u804c\u52a1id", required=true) @PathVariable Long dutyId) {
        this.paramsCheck(userId, departmentId, dutyId);
        if (!this.distributionService.has(departmentId, dutyId)) {
            throw new DepartmentNotHasDutyDistributionException();
        }
        Position position = new Position();
        position.setDepartmentId(departmentId);
        position.setDutyId(dutyId);
        position.setUserId(userId);
        this.positionService.save(position);
    }

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58")
    @PostMapping(value={"/batchSave"})
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(@RequestBody PositionBatchRequest request) {
        Collection<Long> userIds = request.getUserIds();
        Collection<Object> departmentDuties = request.getDepartmentDuties() == null || request.getDepartmentDuties().isEmpty() ? Collections.emptyList() : (Collection)request.getDepartmentDuties().stream().filter(this::departmentDutySaveFilter).collect(Collectors.toList());
        if (userIds == null || userIds.isEmpty() || departmentDuties.isEmpty()) {
            return;
        }
        ArrayList<Position> positions = new ArrayList<Position>(userIds.size() * departmentDuties.size());
        for (Long userId : userIds) {
            for (PositionBatchRequest.DepartmentDuty departmentDuty : departmentDuties) {
                Position position = new Position();
                position.setDepartmentId(departmentDuty.getDepartmentId());
                position.setDutyId(departmentDuty.getDutyId());
                position.setUserId(userId);
                positions.add(position);
            }
        }
        if (!positions.isEmpty()) {
            this.positionService.save(positions);
        }
    }

    private boolean departmentDutySaveFilter(PositionBatchRequest.DepartmentDuty item) {
        if (!this.departmentDutyDeleteFilter(item)) {
            return false;
        }
        return this.distributionService.has(item.getDepartmentId(), item.getDutyId());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{userId}/{departmentId}/{dutyId}"})
    public void delete(@ApiParam(value="\u7528\u6237id", required=true) @PathVariable Long userId, @ApiParam(value="\u90e8\u95e8id", required=true) @PathVariable Long departmentId, @ApiParam(value="\u804c\u52a1id", required=true) @PathVariable Long dutyId) {
        this.paramsCheck(userId, departmentId, dutyId);
        User user = (User)this.userService.selectByIdOptional((Object)userId).orElseThrow(UserInvalidException::new);
        if (Objects.equals(user.getDepartmentId(), departmentId) && Objects.equals(user.getMainDutyId(), dutyId)) {
            throw new MainDutyCannotDeleteException();
        }
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setUserId(userId);
        searchParams.setDepartmentId(departmentId);
        searchParams.setDutyId(dutyId);
        this.positionService.delete(searchParams);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/batchDelete"})
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(@RequestBody PositionBatchRequest request) {
        Collection<Long> userIds = request.getUserIds();
        Collection<Object> departmentDuties = request.getDepartmentDuties() == null || request.getDepartmentDuties().isEmpty() ? Collections.emptyList() : (Collection)request.getDepartmentDuties().stream().filter(this::departmentDutyDeleteFilter).collect(Collectors.toList());
        if (userIds == null || userIds.isEmpty() || departmentDuties.isEmpty()) {
            return;
        }
        for (PositionBatchRequest.DepartmentDuty item : departmentDuties) {
            PositionSearchParams searchParams = new PositionSearchParams();
            searchParams.setUserIds(userIds);
            searchParams.setDepartmentId(item.getDepartmentId());
            searchParams.setDutyId(item.getDutyId());
            this.positionService.delete(searchParams);
        }
    }

    private boolean departmentDutyDeleteFilter(PositionBatchRequest.DepartmentDuty item) {
        if (item == null) {
            return false;
        }
        Long departmentId = item.getDepartmentId();
        Long dutyId = item.getDutyId();
        if (!NumberHelper.greaterZero((Number)departmentId)) {
            return false;
        }
        return dutyId != null && dutyId >= UserAuthConstants.SYSTEM_POSITION_ID_RANGE;
    }

    private void paramsCheck(Long userId, Long departmentId, Long dutyId) {
        if (!NumberHelper.greaterZero((Number)userId)) {
            throw new UserIdInvalidException();
        }
        if (!NumberHelper.greaterZero((Number)departmentId)) {
            throw new DepartmentIdInvalidException();
        }
        if (dutyId == null || dutyId < UserAuthConstants.SYSTEM_POSITION_ID_RANGE) {
            throw new SystemDutyCannotOperationException();
        }
    }

    private void set(Collection<PositionDTO> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.setUser(list);
        this.setDepartment(list);
        this.setDuty(list);
    }

    private void setUser(Collection<PositionDTO> list) {
        Map maps = CollectionUtil.group(list, PositionDTO::getUserId);
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserIds(maps.keySet());
        this.userService.selectAll((AbstractSearchParams)searchParams).forEach(user -> {
            UserDTO dto = (UserDTO)user.toDTO();
            List office = (List)maps.get(user.getUserId());
            if (office != null) {
                office.forEach(o -> o.setUser(dto));
            }
        });
    }

    private void setDepartment(Collection<PositionDTO> list) {
        Map maps = CollectionUtil.group(list, PositionDTO::getDepartmentId);
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setDepartmentIds(maps.keySet());
        this.departmentService.selectAll((AbstractSearchParams)searchParams).forEach(department -> {
            DepartmentDTO dto = (DepartmentDTO)department.toDTO();
            List office = (List)maps.get(department.getDepartmentId());
            if (office != null) {
                office.forEach(o -> o.setDepartment(dto));
            }
        });
    }

    private void setDuty(Collection<PositionDTO> list) {
        Map maps = CollectionUtil.group(list, PositionDTO::getDutyId);
        DutySearchParams searchParams = new DutySearchParams();
        searchParams.setDutyIds(maps.keySet());
        this.dutyService.selectAll((AbstractSearchParams)searchParams).forEach(duty -> {
            DutyDTO dto = (DutyDTO)duty.toDTO();
            List office = (List)maps.get(duty.getDutyId());
            if (office != null) {
                office.forEach(o -> o.setDuty(dto));
            }
        });
    }

    @Autowired
    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @Autowired
    public void setDutyService(DutyService dutyService) {
        this.dutyService = dutyService;
    }

    @Autowired
    public void setDistributionService(DepartmentDutyDistributionService distributionService) {
        this.distributionService = distributionService;
    }
}

