/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.core.domain.DutyDTO;
import net.guerlab.smart.platform.user.core.exception.DutyInvalidException;
import net.guerlab.smart.platform.user.core.searchparams.DutySearchParams;
import net.guerlab.smart.platform.user.service.entity.DepartmentDutyDistribution;
import net.guerlab.smart.platform.user.service.entity.Duty;
import net.guerlab.smart.platform.user.service.service.DepartmentDutyDistributionService;
import net.guerlab.smart.platform.user.service.service.DutyService;
import net.guerlab.spring.commons.dto.ConvertDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u804c\u52a1"})
@RestController(value="/user/duty")
@RequestMapping(value={"/user/duty"})
public class DutyController
extends BaseController<DutyDTO, Duty, DutyService, DutySearchParams, Long> {
    private DepartmentDutyDistributionService distributionService;

    public void copyProperties(DutyDTO dto, Duty entity, Long id) {
        super.copyProperties((Object)dto, (ConvertDTO)entity, (Object)id);
        entity.setDutyId(id);
    }

    protected ApplicationException nullPointException() {
        return new DutyInvalidException();
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u5206\u914d\u8be5\u804c\u52a1\u7684\u90e8\u95e8")
    @GetMapping(value={"/distribution/{dutyId}"})
    public Collection<Long> getDistribution(@ApiParam(value="\u804c\u52a1ID", required=true) @PathVariable Long dutyId) {
        return this.distributionService.findDepartmentIdByDutyId(dutyId);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u53ef\u5206\u914d\u8be5\u804c\u52a1\u7684\u90e8\u95e8")
    @PostMapping(value={"/distribution/{dutyId}"})
    @Transactional(rollbackFor={Exception.class})
    public void setDistribution(@ApiParam(value="\u804c\u52a1ID", required=true) @PathVariable Long dutyId, @ApiParam(value="\u90e8\u95e8ID\u96c6\u5408", required=true) @RequestBody Collection<Long> departmentIds) {
        this.distributionService.deleteByDutyId(dutyId);
        if (CollectionUtil.isEmpty(departmentIds)) {
            return;
        }
        Collection list = departmentIds.stream().map(departmentId -> new DepartmentDutyDistribution(departmentId, dutyId)).collect(Collectors.toList());
        this.distributionService.save(list);
    }

    @Autowired
    public void setDistributionService(DepartmentDutyDistributionService distributionService) {
        this.distributionService = distributionService;
    }
}

