/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.platform.commons.util.UpdateUtils;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.core.domain.DepartmentDTO;
import net.guerlab.smart.platform.user.core.exception.DepartmentInvalidException;
import net.guerlab.smart.platform.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.smart.platform.user.service.entity.Department;
import net.guerlab.smart.platform.user.service.entity.DepartmentDutyDistribution;
import net.guerlab.smart.platform.user.service.service.DepartmentDutyDistributionService;
import net.guerlab.smart.platform.user.service.service.DepartmentService;
import net.guerlab.smart.platform.user.web.domain.ManagerSetterDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u90e8\u95e8"})
@RestController(value="/user/department")
@RequestMapping(value={"/user/department"})
public class DepartmentController
extends BaseController<DepartmentDTO, Department, DepartmentService, DepartmentSearchParams, Long> {
    private DepartmentDutyDistributionService distributionService;

    public DepartmentDTO update(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u90e8\u95e8\u4fe1\u606f", required=true) @RequestBody DepartmentDTO dto) {
        Department department = (Department)this.findOne0(id);
        String departmentName = dto.getDepartmentName();
        String nowDepartmentName = department.getDepartmentName();
        Long parentId = dto.getParentId();
        Long nowParentId = department.getParentId();
        BeanUtils.copyProperties((Object)dto, (Object)department);
        department.setDepartmentId(id);
        department.setDepartmentName((String)UpdateUtils.getUpdateValue((Object)departmentName, (Object)nowDepartmentName));
        department.setParentId((Long)UpdateUtils.getUpdateValue((Object)parentId, (Object)nowParentId));
        ((DepartmentService)this.service).updateSelectiveById((Object)department);
        return (DepartmentDTO)((Department)this.findOne0(id)).toDTO();
    }

    protected ApplicationException nullPointException() {
        return new DepartmentInvalidException();
    }

    @ApiOperation(value="\u83b7\u53d6\u6811\u72b6\u90e8\u95e8\u7ed3\u6784")
    @GetMapping(value={"/tree"})
    public Collection<DepartmentDTO> tree() {
        return TreeUtils.tree((Collection)this.findAll(null));
    }

    @ApiOperation(value="\u8bbe\u7f6e\u4e3b\u7ba1\u9886\u5bfc")
    @PostMapping(value={"/directorUser"})
    public void setDirectorUser(@ApiParam(value="\u90e8\u95e8\u7ba1\u7406\u8bbe\u7f6e", required=true) @RequestBody ManagerSetterDTO setter) {
        ((DepartmentService)this.service).setDirectorUser(setter.getDepartmentId(), setter.getUserId());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5206\u7ba1\u9886\u5bfc")
    @PostMapping(value={"/chargeUser"})
    public void setChargeUser(@ApiParam(value="\u90e8\u95e8\u7ba1\u7406\u8bbe\u7f6e", required=true) @RequestBody ManagerSetterDTO setter) {
        ((DepartmentService)this.service).setChargeUser(setter.getDepartmentId(), setter.getUserId());
    }

    @ApiOperation(value="\u5220\u9664\u4e3b\u7ba1\u9886\u5bfc")
    @DeleteMapping(value={"/directorUser/{departmentId}"})
    public void removeDirectorUser(@ApiParam(value="\u90e8\u95e8id", required=true) @PathVariable Long departmentId) {
        ((DepartmentService)this.service).removeDirectorUser(departmentId);
    }

    @ApiOperation(value="\u5220\u9664\u5206\u7ba1\u9886\u5bfc")
    @DeleteMapping(value={"/chargeUser/{departmentId}"})
    public void removeChargeUser(@ApiParam(value="\u90e8\u95e8id", required=true) @PathVariable Long departmentId) {
        ((DepartmentService)this.service).removeChargeUser(departmentId);
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u5df2\u5206\u914d\u7684\u804c\u52a1ID")
    @GetMapping(value={"/distribution/{departmentId}"})
    public Collection<Long> getDistribution(@ApiParam(value="\u90e8\u95e8id", required=true) @PathVariable Long departmentId) {
        return this.distributionService.findDutyIdByDepartmentId(departmentId);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u90e8\u95e8\u53ef\u5206\u914d\u7684\u804c\u52a1")
    @PostMapping(value={"/distribution/{departmentId}"})
    @Transactional(rollbackFor={Exception.class})
    public void setDistribution(@ApiParam(value="\u90e8\u95e8id", required=true) @PathVariable Long departmentId, @ApiParam(value="\u804c\u52a1ID\u96c6\u5408", required=true) @RequestBody Collection<Long> dutyIds) {
        this.distributionService.deleteByDepartmentId(departmentId);
        if (CollectionUtil.isEmpty(dutyIds)) {
            return;
        }
        Collection list = dutyIds.stream().map(dutyId -> new DepartmentDutyDistribution(departmentId, dutyId)).collect(Collectors.toList());
        this.distributionService.save(list);
    }

    @Autowired
    public void setDistributionService(DepartmentDutyDistributionService distributionService) {
        this.distributionService = distributionService;
    }
}

