/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.commons;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.platform.user.core.domain.UserDTO;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.service.UserService;
import net.guerlab.spring.upload.config.PathInfoConfig;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237"})
@RestController(value="/commons/user")
@RequestMapping(value={"/commons/user"})
public class UserController
extends BaseFindController<UserDTO, User, UserService, UserSearchParams, Long> {
    @ApiOperation(value="\u83b7\u53d6\u5934\u50cf")
    @GetMapping(value={"/{id}/avatar"})
    public void avatar(@ApiParam(value="id", required=true) @PathVariable Long id, HttpServletResponse response) {
        String avatarUrl = this.findAvatar(id);
        String completePath = PathInfoConfig.getSaveBaseDir() + (String)(avatarUrl.startsWith("/") ? avatarUrl : "/" + avatarUrl);
        File file = new File(completePath);
        if (!file.exists() || !file.canRead()) {
            response.setStatus(404);
            return;
        }
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.addHeader("Content-Type", "image/jpeg");
            StreamUtils.copy((InputStream)new FileInputStream(file), (OutputStream)outputStream);
        }
        catch (Exception e) {
            response.setStatus(404);
        }
    }

    private String findAvatar(Long id) {
        User user = (User)((UserService)this.service).selectById((Object)id);
        return user == null ? "/avatar/default.png" : user.getAvatar();
    }
}

