/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller;

import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.basic.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.commons.exception.PasswordErrorException;
import net.guerlab.smart.platform.commons.exception.ThirdPartyIdInvalidException;
import net.guerlab.smart.platform.commons.exception.UserNotFindException;
import net.guerlab.smart.platform.server.utils.IpUtils;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.platform.user.auth.utils.UserJwtHelper;
import net.guerlab.smart.platform.user.core.domain.UserDTO;
import net.guerlab.smart.platform.user.core.entity.UserOauthDTO;
import net.guerlab.smart.platform.user.core.exception.UserHasBoundException;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.entity.UserOauth;
import net.guerlab.smart.platform.user.service.searchparams.UserOauthSearchParams;
import net.guerlab.smart.platform.user.service.service.LoginLogService;
import net.guerlab.smart.platform.user.service.service.UserOauthService;
import net.guerlab.smart.platform.user.service.service.UserService;
import net.guerlab.smart.platform.user.web.domain.BindRequest;
import net.guerlab.smart.platform.user.web.domain.LoginResponse;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Transactional(rollbackFor={Exception.class})
public abstract class AbstractOauthControlPanelController {
    private UserService userService;
    private UserOauthService userOauthService;
    private LoginLogService loginLogService;
    private UserJwtHelper jwtHelper;

    protected abstract String getOauthType();

    @IgnoreLogin
    @ApiOperation(value="\u7ed1\u5b9a")
    @PostMapping(value={"/bind"})
    public LoginResponse bind(@RequestBody BindRequest bindRequest, HttpServletRequest request) {
        String thirdPartyId = StringUtils.trimToNull((String)bindRequest.getThirdPartyId());
        if (thirdPartyId == null) {
            throw new ThirdPartyIdInvalidException();
        }
        if (this.findUser(thirdPartyId) != null) {
            throw new UserHasBoundException();
        }
        User user = this.userService.selectByUsername(bindRequest.getUsername());
        if (user == null) {
            throw new UserNotFindException();
        }
        if (this.getBind(user.getUserId()) != null) {
            throw new UserHasBoundException();
        }
        if (this.userService.checkPasswordError(user, bindRequest.getPassword())) {
            throw new PasswordErrorException();
        }
        UserOauth userOauth = new UserOauth();
        userOauth.setUserId(user.getUserId());
        userOauth.setType(this.getOauthType());
        userOauth.setThirdPartyId(thirdPartyId);
        this.userOauthService.insert((Object)userOauth);
        return this.getLoginSucceedDTO(user, thirdPartyId, request, this.getOauthType());
    }

    @ApiOperation(value="\u89e3\u7ed1")
    @PostMapping(value={"/unbind"})
    public void bind() {
        Long userId = UserContextHandler.getUserId();
        UserOauth userOauth = new UserOauth();
        userOauth.setUserId(userId);
        userOauth.setType(this.getOauthType());
        this.userOauthService.delete((Object)userOauth);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ed1\u5b9a\u72b6\u6001")
    @GetMapping(value={"/bindStatus"})
    public boolean bindStatus() {
        return this.getBind(UserContextHandler.getUserId()) != null;
    }

    protected LoginResponse getLoginSucceedDTO(User user, String openId, HttpServletRequest request, String loginType) {
        LoginResponse loginResponse = user == null ? new LoginResponse() : this.getLoginSucceedDTO(user);
        UserOauth userOauth = new UserOauth();
        userOauth.setUserId(user == null ? null : user.getUserId());
        userOauth.setType(this.getOauthType());
        userOauth.setThirdPartyId(openId);
        loginResponse.setThirdParty((UserOauthDTO)userOauth.toDTO());
        if (user == null) {
            return loginResponse;
        }
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserId(user.getUserId());
        User updateInfo = new User();
        updateInfo.setLastLoginTime(LocalDateTime.now());
        this.userService.updateByExampleSelective((Object)updateInfo, this.userService.getExample((AbstractSearchParams)searchParams));
        this.loginLogService.addSuccessLog(user.getUserId(), user.getName(), openId, loginType, IpUtils.getIp((HttpServletRequest)request));
        return loginResponse;
    }

    protected UserOauth getBind(Long userId) {
        UserOauthSearchParams oauthSearchParams = new UserOauthSearchParams();
        oauthSearchParams.setUserId(userId);
        oauthSearchParams.setType(this.getOauthType());
        return (UserOauth)this.userOauthService.selectOne((AbstractSearchParams)oauthSearchParams);
    }

    protected User findUser(String openId) {
        UserOauthSearchParams oauthSearchParams = new UserOauthSearchParams();
        oauthSearchParams.setType(this.getOauthType());
        oauthSearchParams.setThirdPartyId(openId);
        UserOauth userOauth = (UserOauth)this.userOauthService.selectOne((AbstractSearchParams)oauthSearchParams);
        if (userOauth == null || !NumberHelper.greaterZero((Number)userOauth.getUserId())) {
            return null;
        }
        return (User)this.userService.selectById((Object)userOauth.getUserId());
    }

    protected LoginResponse getLoginSucceedDTO(User user) {
        UserDTO dto = (UserDTO)user.toDTO();
        LoginResponse loginSucceedDTO = new LoginResponse();
        loginSucceedDTO.setInfo(dto);
        loginSucceedDTO.setAccessToken(this.jwtHelper.generateByAccessToken((Object)user));
        loginSucceedDTO.setRefreshToken(this.jwtHelper.generateByRefreshToken((Object)user));
        return loginSucceedDTO;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    public void setUserOauthService(UserOauthService userOauthService) {
        this.userOauthService = userOauthService;
    }

    @Autowired
    public void setLoginLogService(LoginLogService loginLogService) {
        this.loginLogService = loginLogService;
    }

    @Autowired
    public void setJwtHelper(UserJwtHelper jwtHelper) {
        this.jwtHelper = jwtHelper;
    }
}

