package net.guerlab.smart.platform.user.web.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Collection;

/**
 * 职位批量编辑请求
 *
 * @author guer
 */
@Data
@ApiModel("职位批量编辑请求")
public class PositionBatchRequest {

    @ApiModelProperty("用户ID列表")
    private Collection<Long> userIds;

    @ApiModelProperty("职位批量编辑请求-部门职位信息列表")
    private Collection<DepartmentDuty> departmentDuties;

    /**
     * 职位批量编辑请求-部门职位信息
     */
    @Data
    @ApiModel("职位批量编辑请求-部门职位信息")
    public static class DepartmentDuty {

        @ApiModelProperty("部门ID")
        private Long departmentId;

        @ApiModelProperty("职位ID")
        private Long dutyId;
    }
}
