/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.sdk.dingtalk.request.AbstractDingTalkRequest;
import net.guerlab.sdk.dingtalk.request.user.UserGetUserInfoRequest;
import net.guerlab.sdk.dingtalk.response.user.UserGetUserInfoResponse;
import net.guerlab.smart.platform.basic.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.commons.exception.UnsupportedLoginModeException;
import net.guerlab.smart.platform.commons.exception.UserIdInvalidException;
import net.guerlab.smart.platform.user.web.controller.AbstractOauthControlPanelController;
import net.guerlab.smart.platform.user.web.domain.LoginResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9489\u9489-\u63a7\u5236\u9762\u677f"})
@RestController(value="/user/dingTalk/controlPanel")
@RequestMapping(value={"/user/dingTalk/controlPanel"})
public class DingTalkControlPanelController
extends AbstractOauthControlPanelController {
    private DingTalkClient dingTalkClient;

    protected String getOauthType() {
        return "DING_TALK";
    }

    @IgnoreLogin
    @ApiOperation(value="\u901a\u8fc7code\u767b\u5f55")
    @GetMapping(value={"/loginByCode"})
    public LoginResponse loginByCode(@ApiParam(value="code", required=true) @RequestParam String code, HttpServletRequest request) {
        UserGetUserInfoRequest userGetUserInfoRequest = new UserGetUserInfoRequest();
        userGetUserInfoRequest.setCode(code);
        UserGetUserInfoResponse response = (UserGetUserInfoResponse)this.getDingTalkClient().execute((AbstractDingTalkRequest)userGetUserInfoRequest);
        String userId = response.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new UserIdInvalidException();
        }
        return this.getLoginSucceedDTO(this.findUser(userId), userId, request, this.getOauthType());
    }

    private DingTalkClient getDingTalkClient() {
        if (this.dingTalkClient == null) {
            throw new UnsupportedLoginModeException();
        }
        return this.dingTalkClient;
    }

    @Autowired(required=false)
    public void setDingTalkClient(DingTalkClient dingTalkClient) {
        this.dingTalkClient = dingTalkClient;
    }
}

