/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.basic.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.domain.TwoFactorAuthenticationBindInfo;
import net.guerlab.smart.platform.commons.exception.EnabledTwoFactorAuthenticationException;
import net.guerlab.smart.platform.commons.exception.OtpInvalidException;
import net.guerlab.smart.platform.commons.exception.PasswordErrorException;
import net.guerlab.smart.platform.commons.exception.RefreshTokenInvalidException;
import net.guerlab.smart.platform.commons.exception.TwoFactorAuthenticationFailException;
import net.guerlab.smart.platform.commons.exception.TwoFactorAuthenticationSecretKeyErrorException;
import net.guerlab.smart.platform.commons.exception.UnableTwoFactorAuthenticationException;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.platform.commons.exception.UserNotFindException;
import net.guerlab.smart.platform.commons.exception.UserUnableException;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.platform.commons.util.TwoFactorAuthentication;
import net.guerlab.smart.platform.server.utils.IpUtils;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.platform.user.auth.utils.UserJwtHelper;
import net.guerlab.smart.platform.user.core.domain.LoginLogDTO;
import net.guerlab.smart.platform.user.core.domain.MenuDTO;
import net.guerlab.smart.platform.user.core.domain.PositionDataDTO;
import net.guerlab.smart.platform.user.core.domain.UserDTO;
import net.guerlab.smart.platform.user.core.entity.IJwtInfo;
import net.guerlab.smart.platform.user.core.exception.NeedPasswordException;
import net.guerlab.smart.platform.user.core.searchparams.LoginLogSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.MenuPermissionSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.MenuSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.Menu;
import net.guerlab.smart.platform.user.service.entity.Permission;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.service.LoginLogService;
import net.guerlab.smart.platform.user.service.service.MenuPermissionService;
import net.guerlab.smart.platform.user.service.service.MenuService;
import net.guerlab.smart.platform.user.service.service.PermissionService;
import net.guerlab.smart.platform.user.service.service.PositionGetHandler;
import net.guerlab.smart.platform.user.service.service.UserService;
import net.guerlab.smart.platform.user.web.domain.LoginRequest;
import net.guerlab.smart.platform.user.web.domain.LoginResponse;
import net.guerlab.smart.platform.user.web.domain.UpdatePasswordDTO;
import net.guerlab.spring.commons.dto.ConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.upload.entity.IFileInfo;
import net.guerlab.spring.upload.generator.DateSavePathGenerator;
import net.guerlab.spring.upload.generator.RandomSaveNameGenerator;
import net.guerlab.spring.upload.generator.SaveNameGenerator;
import net.guerlab.spring.upload.generator.SavePathGenerator;
import net.guerlab.spring.upload.helper.UploadFileHelper;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u63a7\u5236\u9762\u677f"})
@Transactional(rollbackFor={Exception.class})
@RestController(value="/user/controlPanel")
@RequestMapping(value={"/user/controlPanel"})
public class ControlPanelController {
    private static final Logger log = LoggerFactory.getLogger(ControlPanelController.class);
    private static final String PREFIX = "USER_JWT RT ";
    private UserJwtHelper jwtHelper;
    private UserService service;
    private MenuPermissionService menuPermissionService;
    private MenuService menuService;
    private PermissionService permissionService;
    private LoginLogService loginLogService;
    private PositionGetHandler positionGetHandler;
    private MessageSource messageSource;

    @IgnoreLogin
    @ApiOperation(value="\u767b\u5f55")
    @PostMapping(value={"/login"})
    public LoginResponse login(@ApiParam(value="\u767b\u5f55\u4fe1\u606f", required=true) @RequestBody LoginRequest loginRequest, HttpServletRequest request) {
        return this.login0(loginRequest, this.service.selectByUsername(loginRequest.getUsername()), request, "username");
    }

    @IgnoreLogin
    @ApiOperation(value="\u624b\u673a\u53f7\u7801\u767b\u5f55")
    @PostMapping(value={"/loginByPhone"})
    public LoginResponse loginByPhone(@ApiParam(value="\u767b\u5f55\u4fe1\u606f", required=true) @RequestBody LoginRequest loginRequest, HttpServletRequest request) {
        return this.login0(loginRequest, this.service.selectByPhone(loginRequest.getUsername()), request, "phone");
    }

    @IgnoreLogin
    @ApiOperation(value="\u90ae\u7bb1\u5730\u5740\u767b\u5f55")
    @PostMapping(value={"/loginByEmail"})
    public LoginResponse loginByEmail(@ApiParam(value="\u767b\u5f55\u4fe1\u606f", required=true) @RequestBody LoginRequest loginRequest, HttpServletRequest request) {
        return this.login0(loginRequest, this.service.selectByEmail(loginRequest.getUsername()), request, "email");
    }

    private LoginResponse login0(LoginRequest loginRequest, User user, HttpServletRequest request, String loginType) {
        Long userId = user == null ? Constants.EMPTY_ID : user.getUserId();
        String name = user == null ? "" : user.getName();
        String loginIdentity = loginRequest.getUsername();
        String ip = IpUtils.getIp((HttpServletRequest)request);
        UserNotFindException exception = null;
        if (user == null) {
            exception = new UserNotFindException();
        } else if (!user.getEnabled().booleanValue()) {
            exception = new UserUnableException();
        } else if (this.service.checkPasswordError(user, loginRequest.getPassword())) {
            exception = new PasswordErrorException();
        }
        if (exception != null) {
            this.loginLogService.addFailLog(userId, name, loginIdentity, loginType, ip, exception.getMessage(this.messageSource));
            throw exception;
        }
        if (user.getEnableTwoFactorAuthentication().booleanValue()) {
            this.checkTwoFactorAuthentication(loginRequest, user);
        }
        this.loginLogService.addSuccessLog(userId, name, loginIdentity, loginType, ip);
        return this.buildLoginResponse(user, request, loginType);
    }

    @IgnoreLogin
    @ApiOperation(value="\u5237\u65b0Token")
    @GetMapping(value={"/refreshToken"})
    public LoginResponse refreshToken(@ApiParam(value="refreshToken", required=true) @RequestHeader(value="refreshToken") String refreshToken) {
        if (!refreshToken.startsWith(PREFIX)) {
            throw new RefreshTokenInvalidException();
        }
        String jwtToken = refreshToken.substring(PREFIX.length());
        IJwtInfo infoFromToken = (IJwtInfo)this.jwtHelper.parseByRefreshTokenKey(jwtToken);
        return this.getLoginSucceedDTO((User)this.service.selectById((Object)infoFromToken.getUserId()));
    }

    private LoginResponse buildLoginResponse(User user, HttpServletRequest request, String loginType) {
        LoginResponse loginResponse = this.getLoginSucceedDTO(user);
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserId(user.getUserId());
        User updateInfo = new User();
        updateInfo.setLastLoginTime(LocalDateTime.now());
        this.service.updateByExampleSelective((Object)updateInfo, this.service.getExample((AbstractSearchParams)searchParams));
        return loginResponse;
    }

    private void checkTwoFactorAuthentication(LoginRequest request, User user) {
        String otp = StringUtils.trimToNull((String)request.getOtp());
        if (otp == null) {
            throw new OtpInvalidException();
        }
        if (!TwoFactorAuthentication.checkCode((String)user.getTwoFactorAuthenticationToken(), (String)otp)) {
            throw new TwoFactorAuthenticationFailException();
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f")
    @GetMapping
    public UserDTO getInfo() {
        return (UserDTO)this.findCurrentUser().toDTO();
    }

    @ApiOperation(value="\u83b7\u53d6\u53cc\u56e0\u5b50\u8ba4\u8bc1\u8d44\u6599")
    @GetMapping(value={"/twoFactorAuthenticationBindInfo"})
    public TwoFactorAuthenticationBindInfo getTwoFactorAuthenticationBindInfo() {
        User user = this.findCurrentUser();
        if (user.getEnableTwoFactorAuthentication().booleanValue()) {
            throw new EnabledTwoFactorAuthenticationException();
        }
        String secretKey = TwoFactorAuthentication.generateSecretKey();
        String qrBarcode = TwoFactorAuthentication.getQrCode((String)user.getUsername(), (String)secretKey);
        TwoFactorAuthenticationBindInfo bindInfo = new TwoFactorAuthenticationBindInfo();
        bindInfo.setQrBarcode(qrBarcode);
        bindInfo.setSecretKey(secretKey);
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserId(user.getUserId());
        User update = new User();
        update.setEnableTwoFactorAuthentication(Boolean.valueOf(false));
        update.setTwoFactorAuthenticationToken(secretKey);
        this.service.updateByExampleSelective((Object)update, this.service.getExample((AbstractSearchParams)searchParams));
        return bindInfo;
    }

    @ApiOperation(value="\u542f\u7528\u53cc\u56e0\u5b50\u8ba4\u8bc1")
    @PostMapping(value={"/enableTwoFactorAuthentication/{secretKey}"})
    public LoginResponse enableTwoFactorAuthentication(@ApiParam(value="\u53cc\u56e0\u5b50\u8ba4\u8bc1\u5bc6\u94a5", required=true) @PathVariable String secretKey, @ApiParam(value="\u767b\u5f55\u4fe1\u606f", required=true) @RequestBody LoginRequest request) {
        User user = this.findCurrentUser();
        if (user.getEnableTwoFactorAuthentication().booleanValue()) {
            throw new EnabledTwoFactorAuthenticationException();
        }
        if (!Objects.equals(user.getTwoFactorAuthenticationToken(), secretKey)) {
            throw new TwoFactorAuthenticationSecretKeyErrorException();
        }
        this.checkTwoFactorAuthentication(request, user);
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserId(user.getUserId());
        User update = new User();
        update.setEnableTwoFactorAuthentication(Boolean.valueOf(true));
        this.service.updateByExampleSelective((Object)update, this.service.getExample((AbstractSearchParams)searchParams));
        user.setEnableTwoFactorAuthentication(Boolean.valueOf(true));
        return this.getLoginSucceedDTO(user);
    }

    @ApiOperation(value="\u7981\u7528\u53cc\u56e0\u5b50\u8ba4\u8bc1")
    @PostMapping(value={"/disableTwoFactorAuthentication"})
    public LoginResponse disableTwoFactorAuthentication(@ApiParam(value="\u767b\u5f55\u4fe1\u606f", required=true) @RequestBody LoginRequest request) {
        User user = this.findCurrentUser();
        if (!user.getEnableTwoFactorAuthentication().booleanValue()) {
            throw new UnableTwoFactorAuthenticationException();
        }
        this.checkTwoFactorAuthentication(request, user);
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserId(user.getUserId());
        User update = new User();
        update.setEnableTwoFactorAuthentication(Boolean.valueOf(false));
        update.setTwoFactorAuthenticationToken("");
        this.service.updateByExampleSelective((Object)update, this.service.getExample((AbstractSearchParams)searchParams));
        user.setEnableTwoFactorAuthentication(Boolean.valueOf(false));
        user.setTwoFactorAuthenticationToken("");
        return this.getLoginSucceedDTO(user);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/password"})
    public void updatePassword(@ApiParam(value="\u4fee\u6539\u5bc6\u7801\u4fe1\u606f", required=true) @RequestBody UpdatePasswordDTO dto) {
        String newPassword = StringUtils.trimToNull((String)dto.getNewPassword());
        String oldPassword = StringUtils.trimToNull((String)dto.getOldPassword());
        if (newPassword == null) {
            throw new NeedPasswordException();
        }
        if (oldPassword == null) {
            throw new NeedPasswordException();
        }
        User user = this.findCurrentUser();
        if (this.service.checkPasswordError(user, oldPassword)) {
            throw new PasswordErrorException();
        }
        this.service.updatePassword(user.getUserId(), newPassword);
    }

    @ApiOperation(value="\u4fee\u6539\u4e2a\u4eba\u8d44\u6599")
    @PostMapping(value={"/profile"})
    public void updateProfile(@ApiParam(value="\u7528\u6237\u4fe1\u606f", required=true) @RequestBody UserDTO dto) {
        User user = this.findCurrentUser();
        Long userId = user.getUserId();
        BeanUtils.copyProperties((Object)dto, (Object)user);
        this.setNoUpdateField(user, userId);
        this.service.updateSelectiveById((Object)user);
    }

    @ApiOperation(value="\u5934\u50cf\u4e0a\u4f20")
    @PostMapping(value={"/avatar"})
    public UserDTO avatar(@ApiParam(value="\u5934\u50cf\u56fe\u7247\u6587\u4ef6", required=true) @RequestParam MultipartFile file) {
        User user = this.findCurrentUser();
        IFileInfo fileInfo = UploadFileHelper.upload((MultipartFile)file, (SavePathGenerator)new DateSavePathGenerator("avatar"), (SaveNameGenerator)RandomSaveNameGenerator.INSTANCE);
        user.setAvatar(fileInfo.getWebPath());
        User update = new User();
        update.setUserId(user.getUserId());
        update.setAvatar(user.getAvatar());
        update.setVersion(user.getVersion());
        this.service.updateSelectiveById((Object)update);
        return (UserDTO)user.toDTO();
    }

    @ApiOperation(value="\u5220\u9664\u5934\u50cf")
    @PostMapping(value={"/deleteAvatar"})
    public UserDTO deleteAvatar() {
        this.service.deleteAvatar(UserContextHandler.getUserId());
        User user = (User)this.service.selectById((Object)UserContextHandler.getUserId());
        return (UserDTO)BeanConvertUtils.toObject((ConvertDTO)user);
    }

    private void setNoUpdateField(User user, Long userId) {
        user.setPassword(null);
        user.setUsername(null);
        user.setRegistrationTime(null);
        user.setLastLoginTime(null);
        user.setDepartmentId(null);
        user.setDepartmentName(null);
        user.setUserId(userId);
    }

    private LoginResponse getLoginSucceedDTO(User user) {
        UserDTO dto = (UserDTO)user.toDTO();
        LoginResponse loginSucceedDTO = new LoginResponse();
        loginSucceedDTO.setInfo((Object)dto);
        loginSucceedDTO.setAccessToken(this.jwtHelper.generateByAccessToken((Object)user));
        loginSucceedDTO.setRefreshToken(this.jwtHelper.generateByRefreshToken((Object)user));
        if (user.getAdmin().booleanValue()) {
            loginSucceedDTO.setPermissionKeys((Collection)CollectionUtil.toList((Collection)this.permissionService.selectAll(), Permission::getPermissionKey));
        } else {
            loginSucceedDTO.setPermissionKeys(this.service.getPermissionKeys(dto.getUserId()));
        }
        return loginSucceedDTO;
    }

    private User findCurrentUser() {
        User user = (User)this.service.selectByIdOptional((Object)UserContextHandler.getUserId()).orElseThrow(UserInvalidException::new);
        if (!user.getEnabled().booleanValue()) {
            throw new UserUnableException();
        }
        return user;
    }

    @ApiOperation(value="\u83b7\u53d6\u6743\u9650\u5173\u952e\u5b57\u5217\u8868")
    @GetMapping(value={"/permissionKeys"})
    public Collection<String> permissionKeys() {
        return this.service.getPermissionKeys(UserContextHandler.getUserId());
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868")
    @GetMapping(value={"/menus"})
    public Collection<MenuDTO> getMenus(@ApiParam(value="\u57df\u5217\u8868") @RequestParam(value="domains", required=false) String domains) {
        Long userId = UserContextHandler.getUserId();
        String domainsString = StringUtils.trimToNull((String)domains);
        Collection<Object> domainList = domainsString == null ? Collections.emptyList() : (Collection)Arrays.asList(domainsString.split(",")).parallelStream().map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toSet());
        Collection menus = domainList.isEmpty() ? this.getMenusWithoutDomain(userId) : this.getMenusWithDomain(userId, domainList);
        return TreeUtils.tree((Collection)BeanConvertUtils.toList((Collection)menus));
    }

    private Collection<Menu> getMenusWithDomain(Long userId, Collection<String> domainList) {
        if (this.service.isAdmin(userId)) {
            MenuSearchParams searchParams = new MenuSearchParams();
            searchParams.setDomains(domainList);
            return this.menuService.selectAll((AbstractSearchParams)searchParams);
        }
        Collection menuIds = this.getMenuIds(this.service.getPermissionKeys(userId));
        if (CollectionUtil.isBlank((Collection)menuIds)) {
            return Collections.emptyList();
        }
        MenuSearchParams searchParams = new MenuSearchParams();
        searchParams.setMenuIds(menuIds);
        searchParams.setDomains(domainList);
        return this.menuService.selectAll((AbstractSearchParams)searchParams);
    }

    private Collection<Menu> getMenusWithoutDomain(Long userId) {
        if (this.service.isAdmin(userId)) {
            return this.menuService.selectAll();
        }
        Collection menuIds = this.getMenuIds(this.service.getPermissionKeys(userId));
        if (CollectionUtil.isBlank((Collection)menuIds)) {
            return Collections.emptyList();
        }
        MenuSearchParams searchParams = new MenuSearchParams();
        searchParams.setMenuIds(menuIds);
        return this.menuService.selectAll((AbstractSearchParams)searchParams);
    }

    @ApiOperation(value="\u83b7\u53d6\u804c\u4f4d\u6570\u636e\u5217\u8868")
    @GetMapping(value={"/positions"})
    public Collection<PositionDataDTO> getPositions() {
        return this.positionGetHandler.getPosition(UserContextHandler.getUserId());
    }

    private Collection<Long> getMenuIds(Collection<String> permissionKeys) {
        if (CollectionUtil.isBlank(permissionKeys)) {
            return Collections.emptyList();
        }
        MenuPermissionSearchParams searchParams = new MenuPermissionSearchParams();
        searchParams.setPermissionKeys(permissionKeys);
        return this.menuPermissionService.findMenuIdList(searchParams);
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u8bb0\u5f55")
    @GetMapping(value={"/loginLogs"})
    public ListObject<LoginLogDTO> loginLogs(LoginLogSearchParams searchParams) {
        searchParams.setUserId(UserContextHandler.getUserId());
        return BeanConvertUtils.toListObject((ListObject)this.loginLogService.selectPage((AbstractSearchParams)searchParams));
    }

    @Autowired
    public void setJwtHelper(UserJwtHelper jwtHelper) {
        this.jwtHelper = jwtHelper;
    }

    @Autowired
    public void setService(UserService service) {
        this.service = service;
    }

    @Autowired
    public void setMenuPermissionService(MenuPermissionService menuPermissionService) {
        this.menuPermissionService = menuPermissionService;
    }

    @Autowired
    public void setMenuService(MenuService menuService) {
        this.menuService = menuService;
    }

    @Autowired
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Autowired
    public void setLoginLogService(LoginLogService loginLogService) {
        this.loginLogService = loginLogService;
    }

    @Autowired
    public void setPositionGetHandler(PositionGetHandler positionGetHandler) {
        this.positionGetHandler = positionGetHandler;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

