/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.enums.Gender;
import net.guerlab.smart.platform.commons.exception.EmailFormatErrorException;
import net.guerlab.smart.platform.commons.exception.EmailRepeatException;
import net.guerlab.smart.platform.commons.exception.FullNameInvalidException;
import net.guerlab.smart.platform.commons.exception.PhoneFormatErrorException;
import net.guerlab.smart.platform.commons.exception.PhoneNoRepeatException;
import net.guerlab.smart.platform.commons.exception.UserIdInvalidException;
import net.guerlab.smart.platform.commons.exception.UsernameInvalidException;
import net.guerlab.smart.platform.commons.exception.UsernameRepeatException;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.stream.utils.MessageUtils;
import net.guerlab.smart.platform.user.core.UserConstants;
import net.guerlab.smart.platform.user.core.exception.DepartmentInvalidException;
import net.guerlab.smart.platform.user.core.exception.DutyInvalidException;
import net.guerlab.smart.platform.user.core.exception.EmailLengthErrorException;
import net.guerlab.smart.platform.user.core.exception.NameLengthErrorException;
import net.guerlab.smart.platform.user.core.exception.NeedPasswordException;
import net.guerlab.smart.platform.user.core.exception.PhoneLengthErrorException;
import net.guerlab.smart.platform.user.core.exception.UsernameLengthErrorException;
import net.guerlab.smart.platform.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.PositionSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.Department;
import net.guerlab.smart.platform.user.service.entity.Duty;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.mapper.UserMapper;
import net.guerlab.smart.platform.user.service.service.AfterDepartmentUpdateHandler;
import net.guerlab.smart.platform.user.service.service.DepartmentService;
import net.guerlab.smart.platform.user.service.service.DutyPermissionService;
import net.guerlab.smart.platform.user.service.service.DutyService;
import net.guerlab.smart.platform.user.service.service.PositionService;
import net.guerlab.smart.platform.user.service.service.UserService;
import net.guerlab.smart.platform.user.stream.binders.UserAddSenderChannel;
import net.guerlab.smart.platform.user.stream.binders.UserUpdateSenderChannel;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={UserAddSenderChannel.class, UserUpdateSenderChannel.class})
public class UserServiceImpl
extends BaseServiceImpl<User, Long, UserMapper>
implements UserService,
AfterDepartmentUpdateHandler {
    private DepartmentService departmentService;
    private PositionService positionService;
    private DutyPermissionService dutyPermissionService;
    private DutyService dutyService;
    private PasswordEncoder passwordEncoder;
    private UserAddSenderChannel userAddSenderChannel;
    private UserUpdateSenderChannel userUpdateSenderChannel;

    @Override
    public void afterDepartmentUpdateHandler(Department department) {
        if (department == null || !NumberHelper.greaterZero((Number)department.getDepartmentId()) || StringUtils.isBlank((CharSequence)department.getDepartmentName())) {
            return;
        }
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setMainDepartmentId(department.getDepartmentId());
        User user = new User();
        user.setDepartmentName(department.getDepartmentName());
        ((UserMapper)this.mapper).updateByExampleSelective((Object)user, this.getExample((AbstractSearchParams)searchParams));
    }

    @Override
    public ListObject<User> queryPage(UserSearchParams searchParams) {
        Collection<Long> userIds = this.getUserIds(searchParams);
        if (userIds != null && userIds.isEmpty()) {
            return ListObject.empty();
        }
        searchParams.setUserIds(userIds);
        return this.selectPage((AbstractSearchParams)searchParams);
    }

    @Override
    public Collection<User> queryAll(UserSearchParams searchParams) {
        Collection<Long> userIds = this.getUserIds(searchParams);
        if (userIds != null && userIds.isEmpty()) {
            return Collections.emptyList();
        }
        searchParams.setUserIds(userIds);
        return this.selectAll((AbstractSearchParams)searchParams);
    }

    @Override
    public void updatePassword(Long userId, String newPassword) {
        if (!NumberHelper.greaterZero((Number)userId)) {
            throw new UserIdInvalidException();
        }
        User user = new User();
        user.setPassword(this.getPassword(newPassword));
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserId(userId);
        ((UserMapper)this.mapper).updateByExampleSelective((Object)user, this.getExample((AbstractSearchParams)searchParams));
    }

    @Override
    public boolean checkPasswordError(User user, String password) {
        String pwd = StringUtils.trimToNull((String)password);
        return user == null || pwd == null || !this.passwordEncoder.matches((CharSequence)pwd, user.getPassword());
    }

    @Override
    public Collection<String> getPermissionKeys(Long userId) {
        return this.dutyPermissionService.findPermissionKeyList(this.positionService.findByUserId(userId));
    }

    @Override
    public boolean isAdmin(Long userId) {
        User user = (User)((Object)this.selectById(userId));
        return user != null && user.getAdmin() != null && user.getAdmin() != false;
    }

    @Override
    public void deleteAvatar(Long userId) {
        if (!NumberHelper.greaterZero((Number)userId)) {
            throw new UserIdInvalidException();
        }
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUserId(userId);
        User user = new User();
        user.setAvatar("/avatar/default.png");
        ((UserMapper)this.mapper).updateByExampleSelective((Object)user, this.getExample((AbstractSearchParams)searchParams));
    }

    protected void insertBefore(User entity) {
        this.checkProperties(entity);
        this.initProperties(entity);
        this.departmentCheck(entity);
        Long mainDutyId = entity.getMainDutyId();
        if (mainDutyId == null || mainDutyId < UserConstants.SYSTEM_POSITION_ID_RANGE) {
            entity.setMainDutyId(Constants.EMPTY_ID);
            entity.setMainDutyName("");
        } else {
            entity.setMainDutyName(((Duty)((Object)this.dutyService.selectByIdOptional(mainDutyId).orElseThrow(DutyInvalidException::new))).getDutyName());
            this.positionService.save(entity.getUserId(), entity.getDepartmentId(), mainDutyId);
        }
    }

    protected void insertAfter(User entity) {
        this.positionService.save(entity.getUserId(), entity.getDepartmentId(), UserConstants.POSITION_ID_DEFAULT);
        MessageUtils.send((MessageChannel)this.userAddSenderChannel.output(), (Object)((Object)entity));
    }

    protected void updateBefore(User entity) {
        this.checkName(entity, false);
        this.checkEmail(entity);
        this.checkPhone(entity);
        Long userId = entity.getUserId();
        Long departmentId = entity.getDepartmentId();
        Long oldDepartmentId = entity.getOldDepartmentId();
        if (entity.getEnableTwoFactorAuthentication() == null) {
            entity.setTwoFactorAuthenticationToken(null);
        }
        if (NumberHelper.greaterZero((Number)departmentId)) {
            Department department = (Department)((Object)this.departmentService.selectById(departmentId));
            if (department == null) {
                throw new DepartmentInvalidException();
            }
            entity.setDepartmentName(department.getDepartmentName());
            this.positionService.delete(userId, oldDepartmentId, UserConstants.POSITION_ID_DEFAULT);
            this.positionService.save(userId, departmentId, UserConstants.POSITION_ID_DEFAULT);
        } else {
            entity.setDepartmentId(null);
            entity.setDepartmentName(null);
        }
        Long mainDutyId = entity.getMainDutyId();
        Long oldMainDutyId = entity.getOldMainDutyId();
        if (NumberHelper.greaterOrEqualZero((Number)mainDutyId) && !Objects.equals(mainDutyId, oldMainDutyId)) {
            if (NumberHelper.greaterZero((Number)oldMainDutyId)) {
                this.positionService.delete(userId, oldDepartmentId, oldMainDutyId);
            }
            if (mainDutyId < UserConstants.SYSTEM_POSITION_ID_RANGE) {
                entity.setMainDutyId(Constants.EMPTY_ID);
                entity.setMainDutyName("");
            } else {
                Long depId = departmentId == null ? oldDepartmentId : departmentId;
                entity.setMainDutyName(((Duty)((Object)this.dutyService.selectByIdOptional(mainDutyId).orElseThrow(DutyInvalidException::new))).getDutyName());
                this.positionService.save(userId, depId, mainDutyId);
            }
        } else {
            entity.setMainDutyId(null);
            entity.setMainDutyName(null);
        }
        String pwd = StringUtils.trimToNull((String)entity.getPassword());
        if (pwd != null) {
            entity.setPassword(this.getPassword(pwd));
        }
        entity.setUpdateTime(LocalDateTime.now());
    }

    protected void updateAfter(User entity) {
        MessageUtils.send((MessageChannel)this.userUpdateSenderChannel.output(), (Object)((Object)entity));
    }

    protected void deleteByIdAfter(Long id, Boolean force) {
        this.removePosition(id);
        this.removeCharge(id);
        this.removeDirector(id);
    }

    private Collection<Long> getUserIds(UserSearchParams searchParams) {
        PositionSearchParams positionSearchParams = new PositionSearchParams();
        Collection originUserIds = searchParams.getUserIds();
        boolean needSearch = false;
        if (NumberHelper.greaterZero((Number)searchParams.getDepartmentId())) {
            positionSearchParams.setDepartmentId(searchParams.getDepartmentId());
            positionSearchParams.setUserIds(originUserIds);
            needSearch = true;
        }
        if (NumberHelper.greaterZero((Number)searchParams.getDutyId())) {
            positionSearchParams.setDutyId(searchParams.getDutyId());
            positionSearchParams.setUserIds(originUserIds);
            needSearch = true;
        }
        searchParams.setDepartmentId(null);
        if (!needSearch) {
            return originUserIds;
        }
        if (originUserIds == null || originUserIds.isEmpty()) {
            return this.positionService.findUserIdList(positionSearchParams);
        }
        Collection<Long> userIds = this.positionService.findUserIdList(positionSearchParams);
        if (userIds == null) {
            return Collections.emptyList();
        }
        return originUserIds.stream().filter(NumberHelper::greaterZero).filter(userIds::contains).collect(Collectors.toList());
    }

    private void checkProperties(User entity) {
        String username = StringUtils.trimToNull((String)entity.getUsername());
        if (StringUtils.isBlank((CharSequence)entity.getPassword())) {
            throw new NeedPasswordException();
        }
        if (username == null) {
            throw new UsernameInvalidException();
        }
        if (username.length() > 100) {
            throw new UsernameLengthErrorException();
        }
        if (this.sameCheck(this.selectByUsername(username), entity.getUserId())) {
            throw new UsernameRepeatException();
        }
        entity.setUsername(username);
        this.checkName(entity, true);
        this.checkEmail(entity);
        this.checkPhone(entity);
    }

    private void checkName(User entity, boolean notNull) {
        String name = StringUtils.trimToNull((String)entity.getName());
        if (notNull && name == null) {
            throw new FullNameInvalidException();
        }
        if (name != null && name.length() > 100) {
            throw new NameLengthErrorException();
        }
        entity.setName(name);
    }

    private void checkEmail(User entity) {
        String email = StringUtils.trimToNull((String)entity.getEmail());
        if (email != null) {
            if (email.length() > 100) {
                throw new EmailLengthErrorException();
            }
            if (!Pattern.matches("^[\\.a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$", email)) {
                throw new EmailFormatErrorException();
            }
            if (this.sameCheck(this.selectByEmail(email), entity.getUserId())) {
                throw new EmailRepeatException();
            }
        }
        entity.setEmail(email);
    }

    private void checkPhone(User entity) {
        String phone = StringUtils.trimToNull((String)entity.getPhone());
        if (phone != null) {
            if (phone.length() > 100) {
                throw new PhoneLengthErrorException();
            }
            if (!Pattern.matches("^(\\(\\d{3,4}\\)|\\d{3,4}-|\\s)?\\d{7,14}$", phone)) {
                throw new PhoneFormatErrorException();
            }
            if (this.sameCheck(this.selectByPhone(phone), entity.getUserId())) {
                throw new PhoneNoRepeatException();
            }
        }
        entity.setPhone(phone);
    }

    private boolean sameCheck(User user, Long userId) {
        return user != null && (!NumberHelper.greaterZero((Number)userId) || !Objects.equals(userId, user.getUserId()));
    }

    private void initProperties(User entity) {
        LocalDateTime now = LocalDateTime.now();
        entity.setUserId(this.sequence.nextId());
        entity.setEnabled(true);
        entity.setRegistrationTime(now);
        entity.setUpdateTime(now);
        entity.setPassword(this.getPassword(entity.getPassword()));
        entity.setEnableTwoFactorAuthentication(false);
        entity.setTwoFactorAuthenticationToken("");
        if (entity.getGender() == null) {
            entity.setGender(Gender.OTHER);
        }
        if (entity.getEmail() == null) {
            entity.setEmail("");
        }
        if (entity.getPhone() == null) {
            entity.setPhone("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getAvatar())) {
            entity.setAvatar("/avatar/default.png");
        }
    }

    private void departmentCheck(User entity) {
        Department department;
        Long departmentId = entity.getDepartmentId();
        if (NumberHelper.greaterZero((Number)departmentId) && (department = (Department)((Object)this.departmentService.selectById(departmentId))) != null) {
            entity.setDepartmentName(department.getDepartmentName());
            return;
        }
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setParentId(Constants.DEFAULT_PARENT_ID);
        Department department2 = (Department)((Object)this.departmentService.selectOne((AbstractSearchParams)searchParams));
        if (department2 == null) {
            throw new DepartmentInvalidException();
        }
        entity.setDepartmentId(department2.getDepartmentId());
        entity.setDepartmentName(department2.getDepartmentName());
    }

    private String getPassword(String rawPassword) {
        String pwd = StringUtils.trimToNull((String)rawPassword);
        if (pwd == null) {
            throw new NeedPasswordException();
        }
        return this.passwordEncoder.encode((CharSequence)pwd);
    }

    private void removePosition(Long id) {
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setUserId(id);
        this.positionService.delete(searchParams);
    }

    private void removeCharge(Long id) {
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setChargeUserId(id);
        Department department = new Department();
        department.setChargeUserId(Constants.EMPTY_ID);
        department.setChargeUserName("");
        this.updateDepartment(searchParams, department);
    }

    private void removeDirector(Long id) {
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setDirectorUserId(id);
        Department department = new Department();
        department.setDirectorUserId(Constants.EMPTY_ID);
        department.setDirectorUserName("");
        this.updateDepartment(searchParams, department);
    }

    private void updateDepartment(DepartmentSearchParams searchParams, Department department) {
        Collection departments = this.departmentService.selectAll((AbstractSearchParams)searchParams);
        List departmentIds = CollectionUtil.toList((Collection)departments, Department::getDepartmentId);
        if (CollectionUtil.isEmpty((Collection)departmentIds)) {
            return;
        }
        DepartmentSearchParams departmentSearchParams = new DepartmentSearchParams();
        departmentSearchParams.setDepartmentIds((Collection)departmentIds);
        this.departmentService.updateByExampleSelective((Object)department, this.departmentService.getExample((AbstractSearchParams)departmentSearchParams));
    }

    @Autowired
    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @Autowired
    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    @Autowired
    public void setDutyPermissionService(DutyPermissionService dutyPermissionService) {
        this.dutyPermissionService = dutyPermissionService;
    }

    @Autowired
    public void setDutyService(DutyService dutyService) {
        this.dutyService = dutyService;
    }

    @Autowired
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Autowired
    public void setUserAddSenderChannel(UserAddSenderChannel userAddSenderChannel) {
        this.userAddSenderChannel = userAddSenderChannel;
    }

    @Autowired
    public void setUserUpdateSenderChannel(UserUpdateSenderChannel userUpdateSenderChannel) {
        this.userUpdateSenderChannel = userUpdateSenderChannel;
    }
}

