/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.exception.UserIdInvalidException;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.core.exception.OauthThirdPartyIdInvalidException;
import net.guerlab.smart.platform.user.core.exception.OauthTypeInvalidException;
import net.guerlab.smart.platform.user.core.exception.UserOauthInvalidException;
import net.guerlab.smart.platform.user.service.entity.UserOauth;
import net.guerlab.smart.platform.user.service.mapper.UserOauthMapper;
import net.guerlab.smart.platform.user.service.service.UserOauthService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserOauthServiceImpl
extends BaseServiceImpl<UserOauth, Long, UserOauthMapper>
implements UserOauthService {
    protected void insertBefore(UserOauth entity) {
        if (entity == null) {
            throw new UserOauthInvalidException();
        }
        Long userId = entity.getUserId();
        String type = StringUtils.trimToNull((String)entity.getType());
        String thirdPartyId = StringUtils.trimToNull((String)entity.getThirdPartyId());
        if (!NumberHelper.greaterZero((Number)userId)) {
            throw new UserIdInvalidException();
        }
        if (type == null) {
            throw new OauthTypeInvalidException();
        }
        if (thirdPartyId == null) {
            throw new OauthThirdPartyIdInvalidException();
        }
        entity.setType(type);
        entity.setThirdPartyId(thirdPartyId);
    }
}

