/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.util.TwoFactorAuthentication;
import net.guerlab.smart.platform.user.core.entity.OtpCheckRequest;
import net.guerlab.smart.platform.user.core.entity.OtpCheckResponse;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.service.OtpCheckService;
import net.guerlab.smart.platform.user.service.service.UserService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtpCheckServiceImpl
implements OtpCheckService {
    private UserService userService;

    @Override
    public OtpCheckResponse otpCheck(OtpCheckRequest request) {
        OtpCheckResponse response = new OtpCheckResponse();
        Long userId = request.getUserId();
        String otp = StringUtils.trimToNull((String)request.getOtp());
        if (!NumberHelper.greaterZero((Number)userId) || otp == null) {
            return response;
        }
        User user = (User)((Object)this.userService.selectById(request.getUserId()));
        response.setAccept(user != null && user.getEnableTwoFactorAuthentication() != false && TwoFactorAuthentication.checkCode((String)user.getTwoFactorAuthenticationToken(), (String)otp));
        return response;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

