/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.time.LocalDateTime;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.exception.UserIdInvalidException;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.service.entity.OperationLog;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.mapper.OperationLogMapper;
import net.guerlab.smart.platform.user.service.service.OperationLogService;
import net.guerlab.smart.platform.user.service.service.UserService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OperationLogServiceImpl
extends BaseServiceImpl<OperationLog, Long, OperationLogMapper>
implements OperationLogService {
    private static final String UNKNOWN = "unknown";
    private UserService userService;

    @Override
    @Async
    public void add(OperationLog entity) {
        String operationContent;
        String applicationName = StringUtils.trimToNull((String)entity.getApplicationName());
        if (applicationName == null) {
            applicationName = UNKNOWN;
        }
        if ((operationContent = StringUtils.trimToNull((String)entity.getOperationContent())) == null) {
            operationContent = UNKNOWN;
        }
        User user = this.findUser(entity.getUserId());
        entity.setOperationLogId(this.sequence.nextId());
        entity.setApplicationName(applicationName);
        entity.setOperationTime(LocalDateTime.now());
        entity.setOperationContent(operationContent);
        entity.setOperationParams(StringUtils.trimToEmpty((String)entity.getOperationParams()));
        entity.setUsername(user.getUsername());
        entity.setName(user.getName());
        ((OperationLogMapper)this.mapper).insertSelective(entity);
    }

    private User findUser(Long userId) {
        if (!NumberHelper.greaterZero((Number)userId)) {
            throw new UserIdInvalidException();
        }
        User user = (User)((Object)this.userService.selectById(userId));
        if (user == null) {
            user = new User();
            user.setUsername(UNKNOWN);
            user.setName(UNKNOWN);
        }
        return user;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

