/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.guerlab.smart.platform.user.service.entity.OperationLog;
import net.guerlab.smart.platform.user.service.service.OperationLogHandler;
import net.guerlab.smart.platform.user.service.service.OperationLogService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OperationLogHandlerImpl
implements OperationLogHandler,
ApplicationContextAware {
    private OperationLogService service;
    private ObjectMapper objectMapper;
    private ApplicationContext applicationContext;

    @Override
    @Async
    public void add(String operationContent, Long userId, Object ... operationParams) {
        OperationLog operationLog = new OperationLog();
        operationLog.setApplicationName(this.applicationContext != null ? this.applicationContext.getEnvironment().getProperty("spring.application.name") : null);
        operationLog.setOperationContent(operationContent);
        try {
            operationLog.setOperationParams(this.objectMapper.writeValueAsString((Object)operationParams));
        }
        catch (Exception exception) {
            // empty catch block
        }
        operationLog.setUserId(userId);
        this.service.add(operationLog);
    }

    @Autowired
    public void setService(OperationLogService service) {
        this.service = service;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

