/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.util.Objects;
import java.util.Optional;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.core.exception.MenuKeyInvalidException;
import net.guerlab.smart.platform.user.core.exception.MenuKeyLengthErrorException;
import net.guerlab.smart.platform.user.core.exception.MenuKeyRepeatException;
import net.guerlab.smart.platform.user.core.exception.MenuPathInvalidException;
import net.guerlab.smart.platform.user.core.searchparams.MenuPermissionSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.MenuSearchParams;
import net.guerlab.smart.platform.user.service.entity.Menu;
import net.guerlab.smart.platform.user.service.mapper.MenuMapper;
import net.guerlab.smart.platform.user.service.service.MenuPermissionService;
import net.guerlab.smart.platform.user.service.service.MenuService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
extends BaseServiceImpl<Menu, Long, MenuMapper>
implements MenuService {
    private MenuPermissionService menuPermissionService;

    private Menu selectByKey(String menuKey) {
        MenuSearchParams searchParams = new MenuSearchParams();
        searchParams.setMenuKey(menuKey);
        return (Menu)((Object)this.selectOne((AbstractSearchParams)searchParams));
    }

    protected void insertBefore(Menu entity) {
        String menuKey = StringUtils.trimToNull((String)entity.getMenuKey());
        String path = StringUtils.trimToNull((String)entity.getPath());
        String componentPath = StringUtils.trimToNull((String)entity.getComponentPath());
        if (menuKey == null) {
            throw new MenuKeyInvalidException();
        }
        if (menuKey.length() > 100) {
            throw new MenuKeyLengthErrorException();
        }
        if (this.selectByKey(menuKey) != null) {
            throw new MenuKeyRepeatException();
        }
        if (path == null) {
            throw new MenuPathInvalidException();
        }
        entity.setMenuId(this.sequence.nextId());
        if (!NumberHelper.greaterZero((Number)entity.getParentId())) {
            entity.setParentId(Constants.DEFAULT_PARENT_ID);
        }
        entity.setMenuKey(menuKey);
        entity.setDisplayName(StringUtils.trimToEmpty((String)entity.getDisplayName()));
        entity.setDomain(StringUtils.trimToEmpty((String)entity.getDomain()));
        entity.setModule(StringUtils.trimToEmpty((String)entity.getModule()));
        entity.setPath(path);
        entity.setActiveKey(StringUtils.trimToEmpty((String)entity.getActiveKey()));
        entity.setComponentPath(Optional.ofNullable(componentPath).orElse("Root"));
        entity.setIcon(StringUtils.trimToEmpty((String)entity.getIcon()));
        entity.setIconCls(StringUtils.trimToEmpty((String)entity.getIconCls()));
        if (entity.getHidden() == null) {
            entity.setHidden(false);
        }
        if (entity.getLeaf() == null) {
            entity.setLeaf(false);
        }
        if (entity.getRedirect() == null) {
            entity.setRedirect(false);
        }
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    protected void updateBefore(Menu entity) {
        Menu other;
        entity.setDisplayName(StringUtils.trimToNull((String)entity.getDisplayName()));
        entity.setDomain(StringUtils.trim((String)entity.getDomain()));
        entity.setModule(StringUtils.trim((String)entity.getModule()));
        entity.setPath(StringUtils.trimToNull((String)entity.getPath()));
        entity.setActiveKey(StringUtils.trim((String)entity.getActiveKey()));
        entity.setComponentPath(StringUtils.trimToNull((String)entity.getComponentPath()));
        entity.setIcon(StringUtils.trim((String)entity.getIcon()));
        entity.setIconCls(StringUtils.trim((String)entity.getIconCls()));
        String menuKey = StringUtils.trimToNull((String)entity.getMenuKey());
        if (menuKey != null && (other = this.selectByKey(menuKey)) != null && !Objects.equals(other.getMenuId(), entity.getMenuId())) {
            throw new MenuKeyRepeatException();
        }
        entity.setMenuKey(menuKey);
    }

    protected void deleteByIdAfter(Long menuId, Boolean force) {
        this.clearMenuPermission(menuId);
    }

    private void clearMenuPermission(Long menuId) {
        if (!NumberHelper.greaterZero((Number)menuId)) {
            return;
        }
        MenuPermissionSearchParams searchParams = new MenuPermissionSearchParams();
        searchParams.setMenuId(menuId);
        this.menuPermissionService.delete(searchParams);
    }

    @Autowired
    public void setMenuPermissionService(MenuPermissionService menuPermissionService) {
        this.menuPermissionService = menuPermissionService;
    }
}

