/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseBatchServiceImpl;
import net.guerlab.smart.platform.user.core.searchparams.MenuPermissionSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.MenuSearchParams;
import net.guerlab.smart.platform.user.service.entity.Menu;
import net.guerlab.smart.platform.user.service.entity.MenuPermission;
import net.guerlab.smart.platform.user.service.mapper.MenuPermissionMapper;
import net.guerlab.smart.platform.user.service.service.MenuPermissionService;
import net.guerlab.smart.platform.user.service.service.MenuService;
import net.guerlab.smart.platform.user.service.service.PermissionService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuPermissionServiceImpl
extends BaseBatchServiceImpl<MenuPermission, String, MenuPermissionMapper>
implements MenuPermissionService {
    private PermissionService permissionService;
    private MenuService menuService;

    public Class<MenuPermission> getEntityClass() {
        return MenuPermission.class;
    }

    protected MenuPermission batchSaveBefore(MenuPermission entity) {
        return entity != null && StringUtils.isNotBlank((CharSequence)entity.getPermissionKey()) && NumberHelper.greaterZero((Number)entity.getMenuId()) ? entity : null;
    }

    public List<MenuPermission> findList(MenuPermissionSearchParams searchParams) {
        return ((MenuPermissionMapper)this.mapper).selectByExample(this.getExample((AbstractSearchParams)searchParams));
    }

    @Override
    public void save(String permissionKey, Collection<Long> menuIds) {
        String key = StringUtils.trimToNull((String)permissionKey);
        if (key == null || CollectionUtil.isBlank(menuIds) || this.permissionService.selectById(key) == null) {
            return;
        }
        this.delete(key);
        Collection<Long> filledMenuIds = this.getFilledMenuIds(menuIds);
        if (CollectionUtil.isBlank(filledMenuIds)) {
            return;
        }
        List saves = filledMenuIds.stream().map(menuId -> new MenuPermission(key, (Long)menuId)).collect(Collectors.toList());
        ((MenuPermissionMapper)this.mapper).replaceInsertList(saves);
    }

    private Collection<Long> getFilledMenuIds(Collection<Long> menuIds) {
        MenuSearchParams searchParams = new MenuSearchParams();
        searchParams.setMenuIds(menuIds);
        return CollectionUtil.toSet((Collection)this.menuService.selectAll((AbstractSearchParams)searchParams), Menu::getMenuId);
    }

    @Override
    public void delete(MenuPermissionSearchParams searchParams) {
        ((MenuPermissionMapper)this.mapper).deleteByExample(this.getExample((AbstractSearchParams)searchParams));
    }

    @Autowired
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Autowired
    public void setMenuService(MenuService menuService) {
        this.menuService = menuService;
    }
}

