/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.time.LocalDateTime;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.service.entity.LoginLog;
import net.guerlab.smart.platform.user.service.mapper.LoginLogMapper;
import net.guerlab.smart.platform.user.service.service.LoginLogService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class LoginLogServiceImpl
extends BaseServiceImpl<LoginLog, Long, LoginLogMapper>
implements LoginLogService {
    @Override
    @Async
    public void addSuccessLog(Long userId, String name, String loginIdentity, String loginType, String loginIp) {
        this.addLog(userId, name, loginIdentity, loginType, loginIp, true, "");
    }

    @Override
    @Async
    public void addFailLog(Long userId, String name, String loginIdentity, String loginType, String loginIp, String reason) {
        this.addLog(userId, name, loginIdentity, loginType, loginIp, false, StringUtils.trimToEmpty((String)reason));
    }

    private void addLog(Long userId, String name, String loginIdentity, String loginType, String loginIp, boolean success, String reason) {
        LoginLog entity = new LoginLog();
        entity.setLoginLogId(this.sequence.nextId());
        entity.setUserId(userId);
        entity.setName(name);
        entity.setLoginIdentity(loginIdentity);
        entity.setLoginType(loginType);
        entity.setLoginIp(loginIp);
        entity.setLoginTime(LocalDateTime.now());
        entity.setSuccess(success);
        entity.setReason(reason);
        ((LoginLogMapper)this.mapper).insert(entity);
    }
}

