/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.core.searchparams.DutyPermissionSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.PermissionSearchParams;
import net.guerlab.smart.platform.user.core.utils.PositionUtils;
import net.guerlab.smart.platform.user.service.entity.DutyPermission;
import net.guerlab.smart.platform.user.service.entity.Permission;
import net.guerlab.smart.platform.user.service.entity.Position;
import net.guerlab.smart.platform.user.service.mapper.DutyPermissionMapper;
import net.guerlab.smart.platform.user.service.service.DutyPermissionService;
import net.guerlab.smart.platform.user.service.service.PermissionService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DutyPermissionServiceImpl
extends BaseServiceImpl<DutyPermission, Long, DutyPermissionMapper>
implements DutyPermissionService {
    private PermissionService permissionService;

    private static DutyPermission saveBeforeHandler(DutyPermission dutyPermission) {
        if (StringUtils.isBlank((CharSequence)dutyPermission.getPermissionKey()) || !NumberHelper.allGreaterOrEqualZero((Number[])new Number[]{dutyPermission.getDepartmentId(), dutyPermission.getDutyId()})) {
            return null;
        }
        dutyPermission.setDepartmentDuty(PositionUtils.format((Long)dutyPermission.getDepartmentId(), (Long)dutyPermission.getDutyId()));
        dutyPermission.setPermissionKey(dutyPermission.getPermissionKey());
        return dutyPermission;
    }

    public Class<DutyPermission> getEntityClass() {
        return DutyPermission.class;
    }

    @Override
    public Collection<DutyPermission> findList(DutyPermissionSearchParams searchParams) {
        return ((DutyPermissionMapper)this.mapper).selectByExample(this.getExample((AbstractSearchParams)searchParams));
    }

    @Override
    public Collection<DutyPermission> findList(Collection<Position> list) {
        if (CollectionUtil.isBlank(list)) {
            return Collections.emptyList();
        }
        DutyPermissionSearchParams searchParams = new DutyPermissionSearchParams();
        searchParams.setDepartmentDuties((Collection)PositionUtils.getKeys(list));
        return this.findList(searchParams);
    }

    @Override
    public void save(Long departmentId, Long dutyId, Collection<String> keys) {
        DutyPermissionSearchParams searchParams = new DutyPermissionSearchParams();
        searchParams.setDepartmentId(departmentId);
        searchParams.setDutyId(dutyId);
        this.delete(searchParams);
        if (CollectionUtil.isEmpty(keys)) {
            return;
        }
        this.save0(CollectionUtil.toList(keys, key -> {
            DutyPermission dutyPermission = new DutyPermission();
            dutyPermission.setDepartmentId(departmentId);
            dutyPermission.setPermissionKey(StringUtils.trim((String)key));
            dutyPermission.setDutyId(dutyId);
            return dutyPermission;
        }));
    }

    private void save0(Collection<DutyPermission> list) {
        Collection filled = list.stream().map(DutyPermissionServiceImpl::saveBeforeHandler).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtil.isEmpty((Collection)filled)) {
            return;
        }
        Map keyMap = CollectionUtil.group((Collection)filled, DutyPermission::getPermissionKey);
        Collection<Permission> permissions = this.findPermissionByKeyList(keyMap.keySet());
        ArrayList saves = new ArrayList(filled.size());
        permissions.stream().map(permission -> (List)keyMap.get(permission.getPermissionKey())).filter(CollectionUtil::isNotEmpty).forEach(saves::addAll);
        if (CollectionUtil.isNotEmpty(saves)) {
            ((DutyPermissionMapper)this.mapper).replaceInsertList(saves);
        }
    }

    private Collection<Permission> findPermissionByKeyList(Collection<String> permissionKeyList) {
        PermissionSearchParams searchParams = new PermissionSearchParams();
        searchParams.setPermissionKeys(permissionKeyList);
        return this.permissionService.selectAll((AbstractSearchParams)searchParams);
    }

    @Override
    public void delete(DutyPermissionSearchParams searchParams) {
        ((DutyPermissionMapper)this.mapper).deleteByExample(this.getExample((AbstractSearchParams)searchParams));
    }

    @Autowired
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

