/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service;

import java.util.Collection;
import net.guerlab.smart.platform.server.service.BaseService;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;

public interface UserService
extends BaseService<User, Long> {
    public static final int USERNAME_MAX_LENGTH = 100;
    public static final int NAME_MAX_LENGTH = 100;
    public static final int EMAIL_MAX_LENGTH = 100;
    public static final int PHONE_MAX_LENGTH = 100;
    public static final String DEFAULT_AVATAR_PATH = "avatar";
    public static final String DEFAULT_AVATAR = "/avatar/default.png";

    public ListObject<User> queryPage(UserSearchParams var1);

    public Collection<User> queryAll(UserSearchParams var1);

    default public User selectByUsername(String username) {
        String value = StringUtils.trimToNull((String)username);
        if (value == null) {
            return null;
        }
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setUsername(value);
        return (User)((Object)this.selectOne((AbstractSearchParams)searchParams));
    }

    default public User selectByPhone(String phone) {
        String value = StringUtils.trimToNull((String)phone);
        if (value == null) {
            return null;
        }
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setPhone(value);
        return (User)((Object)this.selectOne((AbstractSearchParams)searchParams));
    }

    default public User selectByEmail(String email) {
        String value = StringUtils.trimToNull((String)email);
        if (value == null) {
            return null;
        }
        UserSearchParams searchParams = new UserSearchParams();
        searchParams.setEmail(value);
        return (User)((Object)this.selectOne((AbstractSearchParams)searchParams));
    }

    public void updatePassword(Long var1, String var2);

    public boolean checkPasswordError(User var1, String var2);

    public Collection<String> getPermissionKeys(Long var1);

    public boolean isAdmin(Long var1);

    public void deleteAvatar(Long var1);

    default public Class<User> getEntityClass() {
        return User.class;
    }
}

