/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.exception.UserIdInvalidException;
import net.guerlab.smart.platform.user.core.exception.DepartmentIdInvalidException;
import net.guerlab.smart.platform.user.core.exception.DutyIdInvalidException;
import net.guerlab.smart.platform.user.core.exception.PositionInvalidException;
import net.guerlab.smart.platform.user.core.searchparams.PositionSearchParams;
import net.guerlab.smart.platform.user.service.entity.Position;
import net.guerlab.web.result.ListObject;

public interface PositionService {
    public Position findOne(PositionSearchParams var1);

    default public boolean has(PositionSearchParams searchParams) {
        return this.findOne(searchParams) != null;
    }

    public Collection<Position> findList(PositionSearchParams var1);

    default public Collection<Long> findUserIdList(PositionSearchParams searchParams) {
        return this.findList(searchParams).stream().map(Position::getUserId).collect(Collectors.toList());
    }

    default public Collection<Long> findDepartmentIdList(PositionSearchParams searchParams) {
        return this.findList(searchParams).stream().map(Position::getDepartmentId).collect(Collectors.toList());
    }

    default public Collection<Long> findDutyIdList(PositionSearchParams searchParams) {
        return this.findList(searchParams).stream().map(Position::getDutyId).collect(Collectors.toList());
    }

    public ListObject<Position> findPage(PositionSearchParams var1);

    default public Collection<Position> findByUserId(Long userId) {
        if (!NumberHelper.greaterZero((Number)userId)) {
            return new ArrayList<Position>();
        }
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setUserId(userId);
        return this.findList(searchParams);
    }

    default public Collection<Position> findByDepartmentId(Long departmentId) {
        if (!NumberHelper.greaterZero((Number)departmentId)) {
            return new ArrayList<Position>();
        }
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setDepartmentId(departmentId);
        return this.findList(searchParams);
    }

    default public void save(Position position) {
        if (position == null) {
            throw new PositionInvalidException();
        }
        if (!NumberHelper.greaterZero((Number)position.getDepartmentId())) {
            throw new DepartmentIdInvalidException();
        }
        if (!NumberHelper.greaterZero((Number)position.getDutyId())) {
            throw new DutyIdInvalidException();
        }
        if (!NumberHelper.greaterZero((Number)position.getUserId())) {
            throw new UserIdInvalidException();
        }
        this.save(Collections.singletonList(position));
    }

    default public void save(Long userId, Long departmentId, Long dutyId) {
        if (!NumberHelper.allGreaterZero((Number[])new Number[]{userId, departmentId, dutyId})) {
            return;
        }
        Position position = new Position();
        position.setUserId(userId);
        position.setDepartmentId(departmentId);
        position.setDutyId(dutyId);
        this.save(position);
    }

    public void save(Collection<Position> var1);

    public void delete(PositionSearchParams var1);

    default public void delete(Position position) {
        if (position == null) {
            return;
        }
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setUserId(position.getUserId());
        searchParams.setDepartmentId(position.getDepartmentId());
        searchParams.setDutyId(position.getDutyId());
        this.delete(searchParams);
    }

    default public void delete(Long userId, Long departmentId, Long dutyId) {
        if (!NumberHelper.allGreaterZero((Number[])new Number[]{userId, departmentId, dutyId})) {
            return;
        }
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setUserId(userId);
        searchParams.setDepartmentId(departmentId);
        searchParams.setDutyId(dutyId);
        this.delete(searchParams);
    }
}

