/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.user.core.domain.PositionDataDTO;
import net.guerlab.smart.platform.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.DutySearchParams;
import net.guerlab.smart.platform.user.service.entity.Department;
import net.guerlab.smart.platform.user.service.entity.Duty;
import net.guerlab.smart.platform.user.service.entity.Position;
import net.guerlab.smart.platform.user.service.service.DepartmentService;
import net.guerlab.smart.platform.user.service.service.DutyService;
import net.guerlab.smart.platform.user.service.service.PositionService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PositionGetHandler {
    private PositionService positionService;
    private DepartmentService departmentService;
    private DutyService dutyService;

    public List<PositionDataDTO> getPosition(Long userId) {
        List positionList;
        Collection<Position> positions = this.positionService.findByUserId(userId);
        if (CollectionUtil.isEmpty(positions)) {
            return Collections.emptyList();
        }
        List positionDTO = BeanConvertUtils.toList(positions, PositionDataDTO.class);
        Map departmentGroup = CollectionUtil.group((Collection)positionDTO, PositionDataDTO::getDepartmentId);
        Map dutyGroup = CollectionUtil.group((Collection)positionDTO, PositionDataDTO::getDutyId);
        Collection<Department> departments = this.getDepartments(departmentGroup.keySet());
        Collection<Duty> duties = this.getDuties(dutyGroup.keySet());
        for (Department department : departments) {
            positionList = (List)departmentGroup.get(department.getDepartmentId());
            if (!CollectionUtil.isNotEmpty((Collection)positionList)) continue;
            ((List)departmentGroup.get(department.getDepartmentId())).forEach(dto -> dto.setDepartmentName(department.getDepartmentName()));
        }
        for (Duty duty : duties) {
            positionList = (List)dutyGroup.get(duty.getDutyId());
            if (!CollectionUtil.isNotEmpty((Collection)positionList)) continue;
            positionList.forEach(dto -> dto.setDutyName(duty.getDutyName()));
        }
        return positionDTO;
    }

    private Collection<Department> getDepartments(Collection<Long> departmentIdList) {
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setDepartmentIds(departmentIdList);
        return this.departmentService.selectAll((AbstractSearchParams)searchParams);
    }

    private Collection<Duty> getDuties(Collection<Long> dutyIdList) {
        DutySearchParams searchParams = new DutySearchParams();
        searchParams.setDutyIds(dutyIdList);
        return this.dutyService.selectAll((AbstractSearchParams)searchParams);
    }

    @Autowired
    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    @Autowired
    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @Autowired
    public void setDutyService(DutyService dutyService) {
        this.dutyService = dutyService;
    }
}

