/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.user.core.searchparams.DepartmentDutyDistributionSearchParams;
import net.guerlab.smart.platform.user.service.entity.DepartmentDutyDistribution;

public interface DepartmentDutyDistributionService {
    public Collection<DepartmentDutyDistribution> find(DepartmentDutyDistributionSearchParams var1);

    default public boolean has(Long departmentId, Long dutyId) {
        if (!NumberHelper.allGreaterZero((Number[])new Number[]{departmentId, dutyId})) {
            return false;
        }
        DepartmentDutyDistributionSearchParams searchParams = new DepartmentDutyDistributionSearchParams();
        searchParams.setDepartmentId(departmentId);
        searchParams.setDutyId(dutyId);
        return !this.find(searchParams).isEmpty();
    }

    default public Collection<Long> findDutyIdByDepartmentId(Long departmentId) {
        if (!NumberHelper.greaterZero((Number)departmentId)) {
            return new ArrayList<Long>();
        }
        DepartmentDutyDistributionSearchParams searchParams = new DepartmentDutyDistributionSearchParams();
        searchParams.setDepartmentId(departmentId);
        return this.find(searchParams).stream().map(DepartmentDutyDistribution::getDutyId).collect(Collectors.toList());
    }

    default public Collection<Long> findDepartmentIdByDutyId(Long dutyId) {
        if (!NumberHelper.greaterZero((Number)dutyId)) {
            return new ArrayList<Long>();
        }
        DepartmentDutyDistributionSearchParams searchParams = new DepartmentDutyDistributionSearchParams();
        searchParams.setDutyId(dutyId);
        return this.find(searchParams).stream().map(DepartmentDutyDistribution::getDepartmentId).collect(Collectors.toList());
    }

    public void save(Collection<DepartmentDutyDistribution> var1);

    public void delete(DepartmentDutyDistributionSearchParams var1);

    default public void deleteByDepartmentId(Long departmentId) {
        if (!NumberHelper.greaterZero((Number)departmentId)) {
            return;
        }
        DepartmentDutyDistributionSearchParams searchParams = new DepartmentDutyDistributionSearchParams();
        searchParams.setDepartmentId(departmentId);
        this.delete(searchParams);
    }

    default public void deleteByDutyId(Long dutyId) {
        if (!NumberHelper.greaterZero((Number)dutyId)) {
            return;
        }
        DepartmentDutyDistributionSearchParams searchParams = new DepartmentDutyDistributionSearchParams();
        searchParams.setDutyId(dutyId);
        this.delete(searchParams);
    }
}

