package net.guerlab.smart.platform.user.service.service;

import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseService;
import net.guerlab.smart.platform.user.core.searchparams.UserOauthSearchParams;
import net.guerlab.smart.platform.user.service.entity.UserOauth;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * 用户oauth信息服务
 *
 * @author guer
 */
public interface UserOauthService extends BaseService<UserOauth, Long> {

    /**
     * 获取一个绑定信息
     *
     * @param type
     *         绑定类型
     * @param userId
     *         用户ID
     * @return 绑定信息
     */
    default UserOauth getOne(String type, Long userId) {
        type = StringUtils.trimToNull(type);
        if (!NumberHelper.greaterZero(userId) || type == null) {
            return null;
        }
        UserOauthSearchParams oauthSearchParams = new UserOauthSearchParams();
        oauthSearchParams.setUserId(userId);
        oauthSearchParams.setType(type);

        return selectOne(oauthSearchParams);
    }

    /**
     * 获取一个绑定信息
     *
     * @param type
     *         绑定类型
     * @param userId
     *         用户ID
     * @return 绑定信息
     */
    default Optional<UserOauth> getOneOptional(String type, Long userId) {
        return Optional.ofNullable(getOne(type, userId));
    }

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<UserOauth> getEntityClass() {
        return UserOauth.class;
    }
}
