package net.guerlab.smart.platform.user.service.service;

import net.guerlab.smart.platform.server.service.BaseFindService;
import net.guerlab.smart.platform.user.service.entity.LoginLog;

/**
 * 登录记录服务
 *
 * @author guer
 */
public interface LoginLogService extends BaseFindService<LoginLog, Long> {

    /**
     * 添加登录成功记录
     *
     * @param userId
     *         用户ID
     * @param name
     *         姓名
     * @param loginIdentity
     *         登录身份
     * @param loginType
     *         登录方式
     * @param loginIp
     *         登录ip
     */
    void addSuccessLog(Long userId, String name, String loginIdentity, String loginType, String loginIp);

    /**
     * 添加登录失败记录
     *
     * @param userId
     *         用户ID
     * @param name
     *         姓名
     * @param loginIdentity
     *         登录身份
     * @param loginType
     *         登录方式
     * @param loginIp
     *         登录ip
     * @param reason
     *         成功标志
     */
    void addFailLog(Long userId, String name, String loginIdentity, String loginType, String loginIp, String reason);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<LoginLog> getEntityClass() {
        return LoginLog.class;
    }
}
