package net.guerlab.smart.platform.user.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.platform.user.core.domain.MenuDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 菜单
 *
 * @author guer
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Table(name = "user_menu")
public class Menu extends BaseOrderEntity<Menu> implements DefaultConvertDTO<MenuDTO> {

    /**
     * 菜单ID
     */
    @Id
    private Long menuId;

    /**
     * 上级ID
     */
    private Long parentId;

    /**
     * 菜单Key
     */
    @Column(name = "menuKey", nullable = false)
    private String menuKey;

    /**
     * 菜单显示名称
     */
    @Column(name = "displayName", nullable = false)
    private String displayName;

    /**
     * 域
     */
    private String domain;

    /**
     * 模块
     */
    private String module;

    /**
     * 访问路径
     */
    @Column(name = "path", nullable = false)
    private String path;

    /**
     * 激活菜单Key
     */
    private String activeKey;

    /**
     * 组件路径
     */
    private String componentPath;

    /**
     * 图标
     */
    private String icon;

    /**
     * 图标类名
     */
    private String iconCls;

    /**
     * 是否隐藏
     */
    @Column(name = "hidden", nullable = false)
    private Boolean hidden;

    /**
     * 是否展示叶节点
     */
    @Column(name = "leaf", nullable = false)
    private Boolean leaf;

    /**
     * 重定向
     */
    @Column(name = "redirect", nullable = false)
    private Boolean redirect;
}
