package net.guerlab.smart.platform.user.service.entity;

import lombok.Data;
import net.guerlab.smart.platform.user.core.domain.LoginLogDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 登录记录
 *
 * @author guer
 */
@Data
@Table(name = "user_login_log")
public class LoginLog implements DefaultConvertDTO<LoginLogDTO> {

    /**
     * 登录记录ID
     */
    @Id
    private Long loginLogId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 登录身份
     */
    private String loginIdentity;

    /**
     * 登录方式
     */
    private String loginType;

    /**
     * 登录IP
     */
    private String loginIp;

    /**
     * 登录时间
     */
    private LocalDateTime loginTime;

    /**
     * 登录成功标志
     */
    private Boolean success;

    /**
     * 失败原因
     */
    private String reason;
}
