/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.guerlab.smart.user.api.feign.FeignUserApi;
import net.guerlab.smart.user.core.domain.PositionDataDTO;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.domain.UserModifyDTO;
import net.guerlab.smart.user.core.entity.LoginResponse;
import net.guerlab.smart.user.core.entity.PasswordRequest;
import net.guerlab.smart.user.core.entity.UserInternalLoginRequest;
import net.guerlab.smart.user.core.utils.PositionUtils;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignUserApiFallbackFactory
implements FallbackFactory<FeignUserApi> {
    public FeignUserApi create(Throwable cause) {
        return new FeignUserApiFallback(cause);
    }

    static class FeignUserApiFallback
    implements FeignUserApi {
        private static final Logger log = LoggerFactory.getLogger(FeignUserApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<UserDTO> findOne(Long userId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<UserDTO> findOneByUsername(String username) {
            log.error("findOneByUsername fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<UserDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<UserDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        @Override
        public Result<List<String>> permissionKeys(Long userId) {
            log.error("permissionKeys fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        @Override
        public Result<Boolean> hasPermission(Long userId, Collection<String> keys) {
            log.error("hasPermission fallback", this.cause);
            return new Fail("fallback", (Object)false);
        }

        @Override
        public Result<List<PositionDataDTO>> getPosition(Long userId) {
            log.error("getPosition fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        @Override
        public Result<Set<String>> getPositionKeys(Long userId) {
            log.error("getPositionKeys fallback", this.cause);
            return new Fail("fallback", Collections.singleton(PositionUtils.ALL_DEPARTMENT_POSITION));
        }

        @Override
        public Result<Boolean> checkPassword(Long userId, PasswordRequest request) {
            log.error("checkPassword fallback", this.cause);
            return new Fail("fallback", (Object)false);
        }

        @Override
        public Result<UserDTO> add(UserModifyDTO user) {
            log.error("add fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<LoginResponse> internalLogin(UserInternalLoginRequest request) {
            log.error("internalLogin fallback", this.cause);
            return new Fail("fallback");
        }

        public FeignUserApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

