/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.user.api.feign.FeignSimpleUserApi;
import net.guerlab.smart.user.core.domain.SimpleUserDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignSimpleUserApiFallbackFactory
implements FallbackFactory<FeignSimpleUserApi> {
    public FeignSimpleUserApi create(Throwable cause) {
        return new FeignSimpleUserApiFallback(cause);
    }

    static class FeignSimpleUserApiFallback
    implements FeignSimpleUserApi {
        private static final Logger log = LoggerFactory.getLogger(FeignSimpleUserApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<SimpleUserDTO> findOne(Long userId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<SimpleUserDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<SimpleUserDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignSimpleUserApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

