/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.user.api.feign.FeignSimpleDepartmentApi;
import net.guerlab.smart.user.core.domain.SimpleDepartmentDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignSimpleDepartmentApiFallbackFactory
implements FallbackFactory<FeignSimpleDepartmentApi> {
    public FeignSimpleDepartmentApi create(Throwable cause) {
        return new FeignSimpleDepartmentApiFallback(cause);
    }

    static class FeignSimpleDepartmentApiFallback
    implements FeignSimpleDepartmentApi {
        private static final Logger log = LoggerFactory.getLogger(FeignSimpleDepartmentApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<SimpleDepartmentDTO> findOne(Long departmentId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<SimpleDepartmentDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<SimpleDepartmentDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignSimpleDepartmentApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

