/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.user.api.feign.FeignOauthApi;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignOauthApiFallbackFactory
implements FallbackFactory<FeignOauthApi> {
    public FeignOauthApi create(Throwable cause) {
        return new FeignOauthApiFallback(cause);
    }

    static class FeignOauthApiFallback
    implements FeignOauthApi {
        private static final Logger log = LoggerFactory.getLogger(FeignOauthApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<OauthDTO> byUserId(String type, Long userId) {
            log.error("byUserId fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<OauthDTO> byThirdPartyId(String type, String thirdPartyId) {
            log.error("byThirdPartyId fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<OauthDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<OauthDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignOauthApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

