/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.user.api.feign.FeignDutyApi;
import net.guerlab.smart.user.core.domain.DutyDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignDutyApiFallbackFactory
implements FallbackFactory<FeignDutyApi> {
    public FeignDutyApi create(Throwable cause) {
        return new FeignDutyApiFallback(cause);
    }

    static class FeignDutyApiFallback
    implements FeignDutyApi {
        private static final Logger log = LoggerFactory.getLogger(FeignDutyApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<DutyDTO> findOne(Long dutyId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<DutyDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<DutyDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignDutyApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

