/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.user.api.feign.FeignDepartmentTypeApi;
import net.guerlab.smart.user.core.domain.DepartmentTypeDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignDepartmentTypeApiFallbackFactory
implements FallbackFactory<FeignDepartmentTypeApi> {
    public FeignDepartmentTypeApi create(Throwable cause) {
        return new FeignDepartmentTypeApiFallback(cause);
    }

    static class FeignDepartmentTypeApiFallback
    implements FeignDepartmentTypeApi {
        private static final Logger log = LoggerFactory.getLogger(FeignDepartmentTypeApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<DepartmentTypeDTO> findOne(String departmentTypeKey) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<DepartmentTypeDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<DepartmentTypeDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignDepartmentTypeApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

