/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.user.api.feign.FeignDepartmentApi;
import net.guerlab.smart.user.core.domain.DepartmentDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignDepartmentApiFallbackFactory
implements FallbackFactory<FeignDepartmentApi> {
    public FeignDepartmentApi create(Throwable cause) {
        return new FeignDepartmentApiFallback(cause);
    }

    static class FeignDepartmentApiFallback
    implements FeignDepartmentApi {
        private static final Logger log = LoggerFactory.getLogger(FeignDepartmentApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<DepartmentDTO> findOne(Long departmentId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<DepartmentDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<DepartmentDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignDepartmentApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

