/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.feign;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.guerlab.smart.user.api.feign.factory.FeignUserApiFallbackFactory;
import net.guerlab.smart.user.core.domain.PositionDataDTO;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.domain.UserModifyDTO;
import net.guerlab.smart.user.core.entity.LoginResponse;
import net.guerlab.smart.user.core.entity.PasswordRequest;
import net.guerlab.smart.user.core.entity.UserInternalLoginRequest;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name="user-internal/inside/user", fallbackFactory=FeignUserApiFallbackFactory.class)
public interface FeignUserApi {
    @GetMapping(value={"/{userId}"})
    public Result<UserDTO> findOne(@PathVariable(value="userId") Long var1);

    @GetMapping(value={"/findOneByUsername/{username}"})
    public Result<UserDTO> findOneByUsername(@PathVariable(value="username") String var1);

    @PostMapping
    public Result<ListObject<UserDTO>> findList(@RequestBody Map<String, Object> var1);

    @PostMapping(value={"/all"})
    public Result<List<UserDTO>> findAll(@RequestBody Map<String, Object> var1);

    @GetMapping(value={"/{userId}/permissionKeys"})
    public Result<List<String>> permissionKeys(@PathVariable(value="userId") Long var1);

    @PostMapping(value={"/{userId}/hasPermission"})
    public Result<Boolean> hasPermission(@PathVariable(value="userId") Long var1, @RequestBody Collection<String> var2);

    @GetMapping(value={"/{userId}/position"})
    public Result<List<PositionDataDTO>> getPosition(@PathVariable(value="userId") Long var1);

    @GetMapping(value={"/{userId}/positionKeys"})
    public Result<Set<String>> getPositionKeys(@PathVariable(value="userId") Long var1);

    @GetMapping(value={"/{userId}/checkPassword"})
    public Result<Boolean> checkPassword(@PathVariable(value="userId") Long var1, @RequestBody PasswordRequest var2);

    @PostMapping(value={"/all"})
    public Result<UserDTO> add(@RequestBody UserModifyDTO var1);

    @PostMapping(value={"/internalLogin"})
    public Result<LoginResponse> internalLogin(@RequestBody UserInternalLoginRequest var1);
}

