/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.api.UserApi;
import net.guerlab.smart.user.core.domain.PositionDataDTO;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.domain.UserModifyDTO;
import net.guerlab.smart.user.core.entity.LoginResponse;
import net.guerlab.smart.user.core.entity.UserInternalLoginRequest;
import net.guerlab.smart.user.core.exception.LoginTypeInvalidException;
import net.guerlab.smart.user.core.exception.NeedPasswordException;
import net.guerlab.smart.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.user.core.utils.PositionUtils;
import net.guerlab.smart.user.service.entity.User;
import net.guerlab.smart.user.service.handler.PositionGetHandler;
import net.guerlab.smart.user.service.service.LoginLogService;
import net.guerlab.smart.user.service.service.PermissionCheckService;
import net.guerlab.smart.user.service.service.PositionService;
import net.guerlab.smart.user.service.service.UserLoginService;
import net.guerlab.smart.user.service.service.UserService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class UserApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={UserService.class})
    public UserApi userApiLocalServiceWrapper(UserService service, PositionGetHandler positionGetHandler, PositionService positionService, PermissionCheckService permissionCheckService, UserLoginService userLoginService, LoginLogService loginLogService) {
        return new UserApiLocalServiceWrapper(service, positionGetHandler, positionService, permissionCheckService, userLoginService, loginLogService);
    }

    private static class UserApiLocalServiceWrapper
    implements UserApi {
        private final UserService service;
        private final PositionGetHandler positionGetHandler;
        private final PositionService positionService;
        private final PermissionCheckService permissionCheckService;
        private final UserLoginService userLoginService;
        private final LoginLogService loginLogService;

        @Override
        public UserDTO findOne(Long userId) {
            return (UserDTO)((User)this.service.selectByIdOptional((Object)userId).orElseThrow(UserInvalidException::new)).toDTO();
        }

        @Override
        public UserDTO findOneByUsername(String username) {
            User user = this.service.selectByUsername(username);
            if (user == null) {
                throw new UserInvalidException();
            }
            return (UserDTO)user.toDTO();
        }

        @Override
        public ListObject<UserDTO> findList(UserSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<UserDTO> findAll(UserSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        @Override
        public UserDTO add(UserModifyDTO dto) {
            String password = StringUtils.trimToNull((String)dto.getPassword());
            if (password == null) {
                throw new NeedPasswordException();
            }
            User user = new User();
            BeanUtils.copyProperties((Object)dto, (Object)user);
            user.setAdmin(Boolean.valueOf(false));
            this.service.insertSelective((Object)user);
            return (UserDTO)user.toDTO();
        }

        @Override
        public LoginResponse internalLogin(UserInternalLoginRequest request) {
            String loginType = StringUtils.trimToNull((String)request.getLoginType());
            if (loginType == null) {
                throw new LoginTypeInvalidException();
            }
            String ip = StringUtils.trimToNull((String)request.getIp());
            if (ip == null) {
                ip = "127.0.0.1";
            }
            User user = (User)this.service.selectByIdOptional((Object)request.getUserId()).orElseThrow(UserInvalidException::new);
            LoginResponse loginResponse = this.userLoginService.login(user, null, ip);
            this.loginLogService.addSuccessLog(user.getUserId(), user.getName(), "USER_ID", loginType, ip);
            return loginResponse;
        }

        @Override
        public List<String> permissionKeys(Long userId) {
            return new ArrayList<String>(this.service.getPermissionKeys(userId));
        }

        @Override
        public boolean hasPermission(Long userId, Collection<String> keys) {
            if (keys == null || keys.isEmpty()) {
                return true;
            }
            return this.permissionCheckService.acceptByPermissionKeys(userId, keys).isAccept();
        }

        @Override
        public List<PositionDataDTO> getPosition(Long userId) {
            return this.positionGetHandler.getPosition(userId);
        }

        @Override
        public Set<String> getPositionKeys(Long userId) {
            return PositionUtils.getKeys((Collection)this.positionService.findByUserId(userId));
        }

        @Override
        public boolean checkPassword(Long userId, String password) {
            User user = (User)this.service.selectById((Object)userId);
            return user != null && !this.service.checkPasswordError(user, password);
        }

        public UserApiLocalServiceWrapper(UserService service, PositionGetHandler positionGetHandler, PositionService positionService, PermissionCheckService permissionCheckService, UserLoginService userLoginService, LoginLogService loginLogService) {
            this.service = service;
            this.positionGetHandler = positionGetHandler;
            this.positionService = positionService;
            this.permissionCheckService = permissionCheckService;
            this.userLoginService = userLoginService;
            this.loginLogService = loginLogService;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                ClassLoader classLoader = WrapperCondition.class.getClassLoader();
                String packageName = "net.guerlab.smart.user.service.service.";
                return classLoader.loadClass(packageName + "UserService") != null && classLoader.loadClass(packageName + "PositionGetHandler") != null && classLoader.loadClass(packageName + "PositionService") != null && classLoader.loadClass(packageName + "PermissionCheckService") != null && classLoader.loadClass(packageName + "UserLoginService") != null && classLoader.loadClass(packageName + "LoginLogService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

