/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.user.api.UserApi;
import net.guerlab.smart.user.api.autoconfig.UserApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignUserApi;
import net.guerlab.smart.user.core.domain.PositionDataDTO;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.domain.UserModifyDTO;
import net.guerlab.smart.user.core.entity.LoginResponse;
import net.guerlab.smart.user.core.entity.PasswordRequest;
import net.guerlab.smart.user.core.entity.UserInternalLoginRequest;
import net.guerlab.smart.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.user.core.utils.PositionUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={UserApiLocalServiceAutoConfigure.class})
public class UserApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={UserApi.class})
    public UserApi userApiFeignWrapper(FeignUserApi api) {
        return new UserApiFeignWrapper(api);
    }

    private static class UserApiFeignWrapper
    implements UserApi {
        private final FeignUserApi api;

        @Override
        public UserDTO findOne(Long userId) {
            return Optional.ofNullable((UserDTO)this.api.findOne(userId).getData()).orElseThrow(UserInvalidException::new);
        }

        @Override
        public UserDTO findOneByUsername(String username) {
            return Optional.ofNullable((UserDTO)this.api.findOneByUsername(username).getData()).orElseThrow(UserInvalidException::new);
        }

        @Override
        public ListObject<UserDTO> findList(UserSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<UserDTO> findAll(UserSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        @Override
        public List<String> permissionKeys(Long userId) {
            return Optional.ofNullable((List)this.api.permissionKeys(userId).getData()).orElse(Collections.emptyList());
        }

        @Override
        public boolean hasPermission(Long userId, Collection<String> keys) {
            return Optional.ofNullable((Boolean)this.api.hasPermission(userId, keys).getData()).orElse(false);
        }

        @Override
        public List<PositionDataDTO> getPosition(Long userId) {
            return Optional.ofNullable((List)this.api.getPosition(userId).getData()).orElse(Collections.emptyList());
        }

        @Override
        public Set<String> getPositionKeys(Long userId) {
            return Optional.ofNullable((Set)this.api.getPositionKeys(userId).getData()).orElse(Collections.singleton(PositionUtils.ALL_DEPARTMENT_POSITION));
        }

        @Override
        public boolean checkPassword(Long userId, String password) {
            if ((password = StringUtils.trimToNull((String)password)) == null) {
                return false;
            }
            PasswordRequest request = new PasswordRequest();
            request.setPassword(password);
            Result<Boolean> result = this.api.checkPassword(userId, request);
            if (result.isStatus() && result.getData() != null) {
                return (Boolean)result.getData();
            }
            return false;
        }

        @Override
        public UserDTO add(UserModifyDTO user) {
            Result<UserDTO> result = this.api.add(user);
            if (result.isStatus() && result.getData() != null) {
                return (UserDTO)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public LoginResponse internalLogin(UserInternalLoginRequest request) {
            Result<LoginResponse> result = this.api.internalLogin(request);
            if (result.isStatus() && result.getData() != null) {
                return (LoginResponse)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        public UserApiFeignWrapper(FeignUserApi api) {
            this.api = api;
        }
    }
}

