/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.api.SimpleUserApi;
import net.guerlab.smart.user.core.domain.SimpleUserDTO;
import net.guerlab.smart.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.user.service.entity.User;
import net.guerlab.smart.user.service.service.UserService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class SimpleUserApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={UserService.class})
    public SimpleUserApi simpleUserApiLocalServiceWrapper(UserService service) {
        return new SimpleUserApiLocalServiceWrapper(service);
    }

    private static class SimpleUserApiLocalServiceWrapper
    implements SimpleUserApi {
        private final UserService service;

        @Override
        public SimpleUserDTO findOne(Long userId) {
            return (SimpleUserDTO)BeanConvertUtils.toObject((Object)((User)this.service.selectByIdOptional((Object)userId).orElseThrow(UserInvalidException::new)), SimpleUserDTO.class);
        }

        @Override
        public ListObject<SimpleUserDTO> findList(UserSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams), SimpleUserDTO.class);
        }

        @Override
        public List<SimpleUserDTO> findAll(UserSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams), SimpleUserDTO.class);
        }

        public SimpleUserApiLocalServiceWrapper(UserService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.user.service.service.UserService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

